<?php
require_once __DIR__ . '/../inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('projects_pages.power_transmission.title', 'Power Transmission');
$pageDescription = t('projects.subtitle', 'Integrated projects in power generation, transmission and cooling systems');
$activePage = 'projects';
include __DIR__ . '/../inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/5 rounded-full blur-2xl"></div>

        <div class="container mx-auto px-4 text-center relative z-10">
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 md:mb-4 drop-shadow-md"><?php echo t('projects_pages.power_transmission.title'); ?></h1>
            <p class="text-base sm:text-lg md:text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
        </div>
    </section>

    <!-- Overhead Transmission Lines -->
    <section id="overhead-lines" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-10">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-2 md:mb-3 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.overhead_lines.title'); ?></h2>
            </div>

            <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/21.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.overhead_lines.image1')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.overhead_lines.image1'); ?></figcaption>
                </figure>
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/22.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.overhead_lines.image2')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.overhead_lines.image2'); ?></figcaption>
                </figure>
            </div>
        </div>
    </section>

    <!-- Substations and GIS -->
    <section id="substations" class="py-12 md:py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-10">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-2 md:mb-3 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.substations.title'); ?></h2>
            </div>
            <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/23.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.substations.image1')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.substations.image1'); ?></figcaption>
                </figure>
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/26.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.substations.image2')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.substations.image2'); ?></figcaption>
                </figure>
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/24.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.substations.image3')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.substations.image3'); ?></figcaption>
                </figure>
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/25.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_transmission.substations.image4')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.substations.image4'); ?></figcaption>
                </figure>
            </div>
        </div>
    </section>

    <!-- Underground Cables -->
    <section id="underground-cables" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-10">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-2 md:mb-3 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.underground_cables.title'); ?></h2>
            </div>
            
            <!-- Main Underground Project -->
            <div class="mb-12 md:mb-16">
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200 shadow-lg">
                    <img src="/assets/img/projects/31.png" alt="Riyadh Metro 380kV GIS and Underground Cable" class="w-full h-64 md:h-96 object-cover">
                    <figcaption class="p-6 md:p-8 rtl:text-right ltr:text-left">
                        <h3 class="text-xl md:text-2xl font-semibold text-gray-800 mb-2 md:mb-3">Riyadh Metro 380kV GIS and 380kV Underground Cable</h3>
                        <p class="text-gray-600 text-base md:text-lg">Advanced underground power transmission infrastructure for Riyadh Metro system</p>
                    </figcaption>
                </figure>
            </div>

            <!-- Underground Cable Projects Grid -->
            <div class="grid sm:grid-cols-2 lg:grid-cols-2 gap-6 md:gap-8">
                <div class="bg-white rounded-xl p-6 md:p-8 border border-gray-200 hover:shadow-lg transition-shadow">
                    <img src="/assets/img/projects/27.png" alt="BSP Circuit 1" class="w-full h-48 md:h-64 object-cover rounded-lg mb-4 md:mb-6">
                    <div class="w-14 h-14 md:w-16 md:h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-4 md:mb-6">
                        <i data-lucide="cable" class="w-8 h-8 text-blue-600"></i>
                    </div>
                    <h4 class="text-lg md:text-xl font-semibold text-gray-800 mb-2 md:mb-3">BSP Circuit 1</h4>
                    <p class="text-gray-600 text-sm md:text-base">Two (2) circuit between BSP (9053) & BSP (9012)</p>
                </div>

                <div class="bg-white rounded-xl p-6 md:p-8 border border-gray-200 hover:shadow-lg transition-shadow">
                    <img src="/assets/img/projects/28.png" alt="BSP Circuit 2" class="w-full h-48 md:h-64 object-cover rounded-lg mb-4 md:mb-6">
                    <div class="w-14 h-14 md:w-16 md:h-16 bg-blue-100 rounded-lg flex items-center justify-center mb-4 md:mb-6">
                        <i data-lucide="cable" class="w-8 h-8 text-blue-600"></i>
                    </div>
                    <h4 class="text-lg md:text-xl font-semibold text-gray-800 mb-2 md:mb-3">BSP Circuit 2</h4>
                    <p class="text-gray-600 text-sm md:text-base">Two (2) circuit between BSP (9053) & BSP (9024)</p>
                </div>

                <div class="bg-white rounded-xl p-6 md:p-8 border border-gray-200 hover:shadow-lg transition-shadow">
                    <img src="/assets/img/projects/29.png" alt="Fiber Optic Project" class="w-full h-48 md:h-64 object-cover rounded-lg mb-4 md:mb-6">
                    <div class="w-14 h-14 md:w-16 md:h-16 bg-green-100 rounded-lg flex items-center justify-center mb-4 md:mb-6">
                        <i data-lucide="wifi" class="w-8 h-8 text-green-600"></i>
                    </div>
                    <h4 class="text-lg md:text-xl font-semibold text-gray-800 mb-2 md:mb-3">Fiber Optic Project</h4>
                    <p class="text-gray-600 text-sm md:text-base">Two (2) circuits between BSP 9053 & Shedgum, along with Fiber Optic Cables Including U/G Tunnel across Said Ibn Zayed Road</p>
                </div>

                <div class="bg-white rounded-xl p-6 md:p-8 border border-gray-200 hover:shadow-lg transition-shadow">
                    <img src="/assets/img/projects/30.png" alt="Major Circuit" class="w-full h-48 md:h-64 object-cover rounded-lg mb-4 md:mb-6">
                    <div class="w-14 h-14 md:w-16 md:h-16 bg-purple-100 rounded-lg flex items-center justify-center mb-4 md:mb-6">
                        <i data-lucide="zap" class="w-8 h-8 text-purple-600"></i>
                    </div>
                    <h4 class="text-lg md:text-xl font-semibold text-gray-800 mb-2 md:mb-3">Major Circuit</h4>
                    <p class="text-gray-600 text-sm md:text-base">Six (6) 380kV Underground cable circuits between BSP (9053) & BSP (9001)</p>
                </div>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/../inc/footer.php'; ?>