<?php
require_once __DIR__ . '/../inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('projects_pages.power_transmission.ongoing_title');
$pageDescription = t('projects_pages.power_transmission.ongoing_desc');
$activePage = 'projects';
include __DIR__ . '/../inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/5 rounded-full blur-2xl"></div>

        <div class="container mx-auto px-4 text-center relative z-10">
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 md:mb-4 drop-shadow-md"><?php echo t('projects_pages.power_transmission.ongoing_title'); ?></h1>
            <p class="text-base sm:text-lg md:text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('projects_pages.power_transmission.ongoing_desc'); ?></p>
        </div>
    </section>

    <!-- Ongoing Projects -->
    <section id="ongoing-projects" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 md:mb-4 text-center rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.ongoing_projects'); ?></h2>
                <p class="text-gray-600 text-center md:text-left max-w-2xl mx-auto md:mx-0 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_transmission.ongoing_desc'); ?></p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-right font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.project'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.start'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.finish'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.value'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.khamis_mushayat'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2015</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2018</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">388</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_waha'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2015</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2017</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">559</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_khalidivah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2013</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">523</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.abu_ali'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">196</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.north_east_metro'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">411</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.south_east_metro'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">274</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_jilah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">454</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.ashbailvah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2013</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2015</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">463</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Completed Projects -->
    <section id="completed-projects" class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="mb-12">
                <h2 class="text-4xl font-bold text-gray-800 mb-4 text-center"><?php echo t('projects_pages.power_transmission.completed_projects'); ?></h2>
                <p class="text-gray-600 text-center max-w-2xl mx-auto"><?php echo t('projects_pages.power_transmission.completed_desc'); ?></p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-right font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.project'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.start'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.finish'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.power_transmission.value'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8102'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">47</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8021'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">31</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8050'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2005</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">32</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.muhayil_north'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2004</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">33</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.khulais_substation'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">89</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_taniem'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">42</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_shogia'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">30</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.doumat_al_jandal'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2008</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">47</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8828'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">65</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_dhahiyah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">72</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/../inc/footer.php'; ?>



