<?php
require_once __DIR__ . '/../inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('projects_pages.power_generation.title', 'Power Generation');
$pageDescription = t('projects.subtitle', 'Integrated projects in power generation, transmission and cooling systems');
$activePage = 'projects';
include __DIR__ . '/../inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/5 rounded-full blur-2xl"></div>

        <div class="container mx-auto px-4 text-center relative z-10">
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 md:mb-4 drop-shadow-md"><?php echo t('projects_pages.power_generation.title'); ?></h1>
            <p class="text-base sm:text-lg md:text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
        </div>
    </section>

    <!-- Simple Cycle Power Plant -->
    <section id="simple-cycle" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-10">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-2 md:mb-3 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_generation.simple_cycle.title'); ?></h2>
                <p class="text-gray-600 text-sm md:text-base rtl:text-right ltr:text-left"><?php echo t('projects.subtitle'); ?></p>
            </div>

            <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/15.jpg" alt="<?php echo htmlspecialchars(t('projects_pages.power_generation.simple_cycle.image1')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left">
                        <?php echo t('projects_pages.power_generation.simple_cycle.image1'); ?>
                    </figcaption>
                </figure>

                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/17.jpg" alt="<?php echo htmlspecialchars(t('projects_pages.power_generation.simple_cycle.image2')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left">
                        <?php echo t('projects_pages.power_generation.simple_cycle.image2'); ?>
                    </figcaption>
                </figure>

                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/16.jpg" alt="<?php echo htmlspecialchars(t('projects_pages.power_generation.simple_cycle.image3')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left">
                        <?php echo t('projects_pages.power_generation.simple_cycle.image3'); ?>
                    </figcaption>
                </figure>

                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/19.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_generation.simple_cycle.image4')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left">
                        <?php echo t('projects_pages.power_generation.simple_cycle.image4'); ?>
                    </figcaption>
                </figure>

                <figure class="bg-white rounded-2xl overflow-hidden border border-gray-200">
                    <img src="/assets/img/projects/200.png" alt="<?php echo htmlspecialchars(t('projects_pages.power_generation.simple_cycle.image5')); ?>" class="w-full h-40 md:h-48 object-cover">
                    <figcaption class="p-4 md:p-5 text-sm text-gray-700 rtl:text-right ltr:text-left">
                        <?php echo t('projects_pages.power_generation.simple_cycle.image5'); ?>
                    </figcaption>
                </figure>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/../inc/footer.php'; ?>
