<?php
require_once __DIR__ . '/../inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('projects_pages.general.all_projects');
$pageDescription = t('projects_pages.general.all_projects');
$activePage = 'projects';
include __DIR__ . '/../inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/5 rounded-full blur-2xl"></div>

        <div class="container mx-auto px-4 text-center relative z-10">
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 md:mb-4 drop-shadow-md"><?php echo t('projects_pages.general.all_projects'); ?></h1>
            <p class="text-base sm:text-lg md:text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
        </div>
    </section>

    <!-- Ongoing Projects -->
    <section id="ongoing-projects" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 md:mb-4 text-center rtl:text-right ltr:text-left"><?php echo t('projects_pages.general.ongoing_projects'); ?></h2>
                <p class="text-gray-600 text-center md:text-left max-w-2xl mx-auto md:mx-0 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_generation.ongoing_desc'); ?></p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 rtl:text-right ltr:text-left font-semibold text-gray-900"><?php echo t('projects_pages.general.category'); ?></th>
                                <th class="px-6 py-4 rtl:text-right ltr:text-left font-semibold text-gray-900"><?php echo t('projects_pages.general.project'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.start'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.finish'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.value'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <!-- Power Generation Ongoing Projects -->
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.hail_conversion'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2018</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">899</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.yanbu_phase3'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2012</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">11,231</td>
                            </tr>
                            
                            <!-- Power Transmission Ongoing Projects -->
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.khamis_mushayat'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2015</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2018</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">388</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_waha'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2015</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2017</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">559</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_khalidivah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2013</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">523</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.abu_ali'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">196</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.north_east_metro'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">411</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.south_east_metro'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">274</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_jilah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2014</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2016</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">454</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.ashbailvah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2013</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2015</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-green-600">463</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <!-- Completed Projects -->
    <section id="completed-projects" class="py-12 md:py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="mb-8 md:mb-12">
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 md:mb-4 text-center rtl:text-right ltr:text-left"><?php echo t('projects_pages.general.completed_projects'); ?></h2>
                <p class="text-gray-600 text-center md:text-left max-w-2xl mx-auto md:mx-0 rtl:text-right ltr:text-left"><?php echo t('projects_pages.power_generation.completed_desc'); ?></p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-200 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 rtl:text-right ltr:text-left font-semibold text-gray-900"><?php echo t('projects_pages.general.category'); ?></th>
                                <th class="px-6 py-4 rtl:text-right ltr:text-left font-semibold text-gray-900"><?php echo t('projects_pages.general.project'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.start'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.finish'); ?></th>
                                <th class="px-6 py-4 text-center font-semibold text-gray-900"><?php echo t('projects_pages.general.value'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <!-- Power Generation Completed Projects -->
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.arar_extension'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 1994</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 1996</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">145</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.tabarjal_extension'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 1999</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2001</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">678</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.pp8_cooling'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2003</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2004</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">88</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.jizan_extension'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2004</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Sep 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">165</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.arar_expansion'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">654</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.rafha_expansion'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">253</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.tihama_extension1'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">195</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.tihama_extension2'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2007</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">233</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.pp8_extension'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2007</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">483</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.faras_extension'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2007</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">461</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.jizan_extension2'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Aug 2008</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Nov 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">585</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.wadi_dawaser'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2008</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2010</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">622</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.tabuk_reinforcement'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2010</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2012</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">620</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-yellow-600"><?php echo t('projects_pages.general.power_generation'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_generation.reinforcement_projects'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2012</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2013</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">328</td>
                            </tr>
                            
                            <!-- Power Transmission Completed Projects -->
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8102'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">47</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8021'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jun 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2004</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">31</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8050'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Oct 2002</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2005</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">32</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.muhayil_north'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2004</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Feb 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">33</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.khulais_substation'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jan 2006</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">89</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_taniem'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">42</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_shogia'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Apr 2005</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2007</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">30</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.doumat_al_jandal'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Mar 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2008</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">47</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.substation_8828'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Jul 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">65</td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4 text-sm font-medium text-blue-600"><?php echo t('projects_pages.general.power_transmission'); ?></td>
                                <td class="px-6 py-4 text-sm text-gray-900"><?php echo t('projects_pages.power_transmission.al_dhahiyah'); ?></td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">May 2006</td>
                                <td class="px-6 py-4 text-sm text-center text-gray-600">Dec 2009</td>
                                <td class="px-6 py-4 text-sm text-center font-semibold text-blue-600">72</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/../inc/footer.php'; ?>



