<?php
require_once __DIR__ . '/inc/utils.php';
$pageTitle = 'Altoukhi - ' . t('megamenu.projects.title', 'Our Projects');
$pageDescription = t('megamenu.projects.subtitle', 'Integrated projects in power generation, transmission and cooling systems');
$activePage = 'projects';
include __DIR__ . '/inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/5 rounded-full blur-2xl"></div>

        <div class="container mx-auto px-4 text-center relative z-10">
            <h2 class="text-5xl font-bold mb-4 drop-shadow-md"><?php echo t('megamenu.projects.title'); ?></h2>
            <p class="text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
        </div>
    </section>

    <!-- Top Categories (three main classifications) -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-10">
                <h3 class="text-3xl font-bold text-gray-800 mb-3"><?php echo t('megamenu.projects.categories'); ?></h3>
                <p class="text-gray-600"><?php echo t('megamenu.projects.subtitle'); ?></p>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <!-- Power Generation -->
                <a href="<?php echo $langPrefix; ?>/projects/power-generation.php#simple-cycle" class="group block rounded-2xl border border-gray-200 bg-white p-8 hover:shadow-lg transition-all duration-300">
                    <div class="w-14 h-14 rounded-xl bg-primary-50 text-primary-600 flex items-center justify-center mb-5">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-7 h-7" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-2 group-hover:text-primary-700"><?php echo t('megamenu.projects.power_generation'); ?></h4>
                    <p class="text-gray-600 text-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
                </a>

                <!-- Power Transmission -->
                <a href="<?php echo $langPrefix; ?>/projects/power-transmission.php#overhead-lines" class="group block rounded-2xl border border-gray-200 bg-white p-8 hover:shadow-lg transition-all duration-300">
                    <div class="w-14 h-14 rounded-xl bg-primary-50 text-primary-600 flex items-center justify-center mb-5">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-7 h-7" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"/></svg>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-2 group-hover:text-primary-700"><?php echo t('megamenu.projects.power_transmission'); ?></h4>
                    <p class="text-gray-600 text-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
                </a>

                <!-- Cooling Systems -->
                <a href="<?php echo $langPrefix; ?>/projects/cooling.php#cooling-solutions" class="group block rounded-2xl border border-gray-200 bg-white p-8 hover:shadow-lg transition-all duration-300">
                    <div class="w-14 h-14 rounded-xl bg-primary-50 text-primary-600 flex items-center justify-center mb-5">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-7 h-7" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/></svg>
                    </div>
                    <h4 class="text-xl font-semibold text-gray-900 mb-2 group-hover:text-primary-700"><?php echo t('megamenu.projects.cooling_systems'); ?></h4>
                    <p class="text-gray-600 text-sm"><?php echo t('megamenu.projects.subtitle'); ?></p>
                </a>
            </div>
        </div>
    </section>

    <!-- All project details are now in sub-pages -->

<?php include __DIR__ . '/inc/footer.php'; ?>

