<?php
require_once __DIR__ . '/inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'الطوخي للمقاولات - شركة مقاولات متخصصة';
$pageDescription = 'شركة الطوخي للمقاولات - متخصصون في البناء والتشييد والمقاولات العامة';
$activePage = 'home';
part('header');
ini_set('display_errors', 1);
error_reporting(E_ALL);
?>

    <!-- Hero Section -->
<?php part('hero'); ?>

    <!-- Services Preview -->
    <section id="services" class="py-10 sm:py-14 md:py-16 bg-white">
        <?php part('services-preview'); ?>
    </section>

    <!-- About Section -->
    

<?php part('about-2'); ?>
    <!-- Safety Measures -->
    <section class="py-10 sm:py-14 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-8">
                <h3 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-2.5 sm:mb-3"><?php echo t('home.safety_title'); ?></h3>
                <p class="text-base sm:text-lg text-gray-600"><?php echo t('home.safety_desc'); ?></p>
            </div>
            <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
                <div class="h-32 sm:h-40 bg-gray-100 rounded-xl flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.safety_image'); ?></div>
                <div class="h-32 sm:h-40 bg-gray-100 rounded-xl flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.safety_image'); ?></div>
                <div class="h-32 sm:h-40 bg-gray-100 rounded-xl flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.safety_image'); ?></div>
            </div>
        </div>
    </section>

    <?php part('featured-clients'); ?>

    <!-- Current Projects -->
    <section class="py-10 sm:py-14 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-8">
                <h3 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-2.5 sm:mb-3"><?php echo t('home.projects_title'); ?></h3>
                <p class="text-base sm:text-lg text-gray-600"><?php echo t('home.projects_desc'); ?></p>
            </div>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                <div class="bg-gray-50 rounded-xl overflow-hidden border border-gray-200">
                    <div class="h-32 sm:h-40 bg-gray-200 flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.project_image'); ?></div>
                    <div class="p-5 sm:p-6">
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-1.5 sm:mb-2"><?php echo t('home.projects_card_title'); ?></h4>
                        <p class="text-gray-600 text-sm"><?php echo t('home.projects_card_desc'); ?></p>
                    </div>
                </div>
                <div class="bg-gray-50 rounded-xl overflow-hidden border border-gray-200">
                    <div class="h-32 sm:h-40 bg-gray-200 flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.project_image'); ?></div>
                    <div class="p-5 sm:p-6">
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-1.5 sm:mb-2"><?php echo t('home.projects_card_title'); ?></h4>
                        <p class="text-gray-600 text-sm"><?php echo t('home.projects_card_desc'); ?></p>
                    </div>
                </div>
                <div class="bg-gray-50 rounded-xl overflow-hidden border border-gray-200">
                    <div class="h-32 sm:h-40 bg-gray-200 flex items-center justify-center text-gray-400 text-sm sm:text-base"><?php echo t('common.project_image'); ?></div>
                    <div class="p-5 sm:p-6">
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-1.5 sm:mb-2"><?php echo t('home.projects_card_title'); ?></h4>
                        <p class="text-gray-600 text-sm"><?php echo t('home.projects_card_desc'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    

   

<?php part('footer'); ?>
