<?php
// Services Preview partial
?>
    <section class="relative py-10 sm:py-14 md:py-16 bg-white overflow-hidden">
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-44 h-44 rounded-full blur-xl opacity-15" style="background-color: rgb(52 46 135 / 0.18);"></div>
        </div>
        <div class="relative container mx-auto px-4">
            <div class="text-center mb-8 sm:mb-10 md:mb-12">
                <h3 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 sm:mb-4"><?php echo t('sections.services_title'); ?></h3>
                <p class="text-base sm:text-lg md:text-xl text-gray-600 max-w-2xl mx-auto"><?php echo t('services_preview.intro'); ?></p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-5 sm:gap-6 md:gap-8">
                <!-- Service 1: Power Generation -->
                <div class="group relative overflow-hidden rounded-2xl border border-gray-200/70 bg-white/80 backdrop-blur-sm shadow-sm hover:shadow-xl transition-colors transition-transform hover:-translate-y-0.5 ring-1 ring-gray-200/50 hover:ring-primary-200/60">
                    <div class="absolute bottom-0 rtl:left-0 ltr:right-0 w-28 h-28 sm:w-32 sm:h-32 md:w-36 md:h-36 lg:w-40 lg:h-40 opacity-55 group-hover:opacity-75 transition-opacity">
                        <img src="/assets/img/arrow-bg.svg" alt="" class="w-full h-full object-contain filter grayscale rtl:scale-x-100 ltr:scale-x-[-1]">
                </div>
                    <div class="pointer-events-none absolute -inset-2 opacity-100">
                        <div class="absolute -top-12 -left-12 w-48 h-48 rounded-full blur-2xl bg-[radial-gradient(circle_at_center,rgba(52,46,135,0.25),transparent_60%)]"></div>
                        <div class="absolute -bottom-16 -right-16 w-56 h-56 rounded-full blur-3xl bg-[radial-gradient(circle_at_center,rgba(14,165,233,0.20),transparent_60%)]"></div>
                    </div>
                    <div class="relative p-6 sm:p-7 md:p-8">
                        <div class="w-12 h-12 sm:w-14 sm:h-14 md:w-16 md:h-16 bg-primary-50 rounded-lg flex items-center justify-center mb-4 sm:mb-5 md:mb-6 group-hover:bg-primary-600/10 transition-colors">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7 md:w-8 md:h-8 text-primary-600 group-hover:text-primary-700 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-2.5 sm:mb-3"><?php echo t('services_preview.card1.title'); ?></h4>
                        <p class="text-sm sm:text-base text-gray-600 mb-5 sm:mb-6"><?php echo t('services_preview.card1.desc'); ?></p>
                        <a href="/contact.php" class="inline-flex items-center gap-1.5 sm:gap-2 text-primary-700 hover:text-primary-800 font-medium text-sm sm:text-base">
                            <?php echo t('common.learn_more'); ?>
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                        </a>
                    </div>
                </div>

                <!-- Service 2: Power Transmission -->
                <div class="group relative overflow-hidden rounded-2xl border border-gray-200/70 bg-white/80 backdrop-blur-sm shadow-sm hover:shadow-xl transition-colors transition-transform hover:-translate-y-0.5 ring-1 ring-gray-200/50 hover:ring-primary-200/60">
                    <div class="absolute bottom-0 rtl:left-0 ltr:right-0 w-28 h-28 sm:w-32 sm:h-32 md:w-36 md:h-36 lg:w-40 lg:h-40 opacity-55 group-hover:opacity-75 transition-opacity">
                        <img src="/assets/img/arrow-bg.svg" alt="" class="w-full h-full object-contain filter grayscale rtl:scale-x-100 ltr:scale-x-[-1]">
                    </div>
                    <!-- glow layers -->
                    <div class="pointer-events-none absolute -inset-2 opacity-100">
                        <div class="absolute -top-12 -right-10 w-44 h-44 rounded-full blur-2xl bg-[radial-gradient(circle_at_center,rgba(52,46,135,0.22),transparent_60%)]"></div>
                        <div class="absolute -bottom-14 -left-12 w-56 h-56 rounded-full blur-3xl bg-[radial-gradient(circle_at_center,rgba(99,102,241,0.18),transparent_60%)]"></div>
                    </div>
                    <div class="relative p-6 sm:p-7 md:p-8">
                        <div class="w-12 h-12 sm:w-14 sm:h-14 md:w-16 md:h-16 bg-primary-50 rounded-lg flex items-center justify-center mb-4 sm:mb-5 md:mb-6 group-hover:bg-primary-600/10 transition-colors">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7 md:w-8 md:h-8 text-primary-600 group-hover:text-primary-700 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12h3m3 0h12M6 12l3-3m-3 3l3 3"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-2.5 sm:mb-3"><?php echo t('services_preview.card2.title'); ?></h4>
                        <p class="text-sm sm:text-base text-gray-600 mb-5 sm:mb-6"><?php echo t('services_preview.card2.desc'); ?></p>
                        <a href="/contact.php" class="inline-flex items-center gap-1.5 sm:gap-2 text-primary-700 hover:text-primary-800 font-medium text-sm sm:text-base">
                            <?php echo t('common.learn_more'); ?>
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                        </a>
                    </div>
                </div>

                <!-- Service 3: Cooling System -->
                <div class="group relative overflow-hidden rounded-2xl border border-gray-200/70 bg-white/80 backdrop-blur-sm shadow-sm hover:shadow-xl transition-colors transition-transform hover:-translate-y-0.5 ring-1 ring-gray-200/50 hover:ring-primary-200/60">
                    <!-- Arrow background shape -->
                    <div class="absolute bottom-0 rtl:left-0 ltr:right-0 w-28 h-28 sm:w-32 sm:h-32 md:w-36 md:h-36 lg:w-40 lg:h-40 opacity-55 group-hover:opacity-75 transition-opacity">
                        <img src="/assets/img/arrow-bg.svg" alt="" class="w-full h-full object-contain filter grayscale rtl:scale-x-100 ltr:scale-x-[-1]">
                    </div>
                    <!-- glow layers -->
                    <div class="pointer-events-none absolute -inset-2 opacity-100">
                        <div class="absolute -top-10 -left-8 w-40 h-40 rounded-full blur-2xl bg-[radial-gradient(circle_at_center,rgba(52,46,135,0.18),transparent_60%)]"></div>
                        <div class="absolute -bottom-20 -right-10 w-60 h-60 rounded-full blur-3xl bg-[radial-gradient(circle_at_center,rgba(14,165,233,0.22),transparent_60%)]"></div>
                    </div>
                    <div class="relative p-6 sm:p-7 md:p-8">
                        <div class="w-12 h-12 sm:w-14 sm:h-14 md:w-16 md:h-16 bg-primary-50 rounded-lg flex items-center justify-center mb-4 sm:mb-5 md:mb-6 group-hover:bg-primary-600/10 transition-colors">
                            <svg class="w-6 h-6 sm:w-7 sm:h-7 md:w-8 md:h-8 text-primary-600 group-hover:text-primary-700 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 12h12M12 6v12m-6.364-6l12.728 0M7.757 7.757l8.486 8.486"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg sm:text-xl font-semibold text-gray-800 mb-2.5 sm:mb-3"><?php echo t('services_preview.card3.title'); ?></h4>
                        <p class="text-sm sm:text-base text-gray-600 mb-5 sm:mb-6"><?php echo t('services_preview.card3.desc'); ?></p>
                        <a href="/contact.php" class="inline-flex items-center gap-1.5 sm:gap-2 text-primary-700 hover:text-primary-800 font-medium text-sm sm:text-base">
                            <?php echo t('common.learn_more'); ?>
                            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

