<?php
require_once __DIR__ . '/utils.php';
$i18n = detect_lang();
$prefix = $i18n['prefix'];
$heroSlides = [
    [
        'image' => '/assets/img/hero/hero-1.png',
        'title' => t('hero.slide1.title'),
        'desc'  => t('hero.slide1.desc'),
        'cta1'  => [ 'label' => t('hero.slide1.cta1'), 'href' => $prefix . '/projects.php', 'primary' => true ],
        'cta2'  => [ 'label' => t('hero.slide1.cta2'), 'href' => $prefix . '/contact.php', 'primary' => false ],
    ],
    [
        'image' => '/assets/img/hero/hero-2.png',
        'title' => t('hero.slide2.title'),
        'desc'  => t('hero.slide2.desc'),
        'cta1'  => [ 'label' => t('hero.slide2.cta1'), 'href' => $prefix . '/projects.php', 'primary' => true ],
        'cta2'  => [ 'label' => t('hero.slide2.cta2'), 'href' => $prefix . '/contact.php', 'primary' => false ],
    ],
    [
        'image' => '/assets/img/hero/hero-3.png',
        'title' => t('hero.slide3.title'),
        'desc'  => t('hero.slide3.desc'),
        'cta1'  => [ 'label' => t('hero.slide3.cta1'), 'href' => $prefix . '/contact.php', 'primary' => true ],
        'cta2'  => [ 'label' => t('hero.slide3.cta2'), 'href' => $prefix . '/contact.php', 'primary' => false ],
    ],
];
$slidesJson = htmlspecialchars(json_encode($heroSlides, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES);
?>
<section class="relative text-white pt-20 lg:pt-52 pb-14 lg:pb-24 overflow-hidden h-[68vh] sm:h-[72vh] lg:h-[90vh] flex items-center" data-hero data-hero-slides="<?php echo $slidesJson; ?>" data-hero-interval="15000">
    <div class="absolute inset-0">
        <div class="absolute inset-0 bg-cover bg-center transition-opacity duration-1000 ease-in-out" data-hero-layer="a" style="opacity:0"></div>
        <div class="absolute inset-0 bg-cover bg-center transition-opacity duration-1000 ease-in-out" data-hero-layer="b" style="opacity:0"></div>
        <div class="absolute inset-0 bg-gradient-to-b from-black/50 via-black/40 to-black/60"></div>
        <div class="pointer-events-none absolute inset-x-0 top-0 h-32 bg-gradient-to-b from-black/40 via-black/20 to-transparent"></div>
        <div class="pointer-events-none absolute inset-x-0 bottom-0 h-36 bg-gradient-to-t from-black/40 via-black/20 to-transparent"></div>
        <div class="pointer-events-none absolute inset-y-0 left-0 w-20 bg-gradient-to-r from-black/30 via-black/12 to-transparent"></div>
        <div class="pointer-events-none absolute inset-y-0 right-0 w-20 bg-gradient-to-l from-black/30 via-black/12 to-transparent"></div>
        <div class="hero-glow"></div>
    </div>
    <div class="relative container mx-auto px-4 text-center">
        <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold mb-3 sm:mb-4 lg:mb-6 fade-in-up hero-text" data-hero-title></h2>
        <p class="text-base sm:text-lg lg:text-xl mb-5 sm:mb-6 lg:mb-8 max-w-2xl lg:max-w-3xl mx-auto fade-in-up hero-text" data-hero-desc></p>
        <div class="flex flex-row flex-nowrap gap-3 sm:gap-4 justify-center fade-in-up hero-text" data-hero-ctas>
            <!-- Primary Button -->
            <a href="<?php echo $prefix; ?>/projects.php" class="btn-asym inline-flex items-center justify-center whitespace-nowrap px-4 py-2.5 sm:px-6 sm:py-3 lg:px-8 lg:py-4 font-medium sm:font-semibold lg:font-bold text-sm sm:text-lg lg:text-xl text-white shadow-md lg:shadow-2xl hover:shadow-lg lg:hover:shadow-xl focus:outline-none focus-visible:ring-4 focus-visible:ring-white/30" style="background: linear-gradient(135deg, #342e87 0%, #2a2570 50%, #1f1a5a 100%);" data-hero-cta1>
                <span class="flex items-center gap-1.5 sm:gap-3">
                    <i data-lucide="building-2" class="w-4 h-4 sm:w-5 sm:h-5"></i>
                    <span data-hero-cta1-text><?php echo t('hero.primary_cta'); ?></span>
                    <i data-lucide="arrow-right" class="w-4 h-4 sm:w-5 sm:h-5"></i>
                </span>
            </a>
            
            <!-- Secondary Button -->
            <a href="<?php echo $prefix; ?>/contact.php" class="btn-asym-mirror inline-flex items-center justify-center whitespace-nowrap px-4 py-2.5 sm:px-6 sm:py-3 lg:px-8 lg:py-4 font-medium sm:font-semibold lg:font-bold text-sm sm:text-lg lg:text-xl text-white border-2 border-white/60 bg-white/10 hover:bg-white/20 shadow-md lg:shadow-xl hover:shadow-white/25 focus:outline-none focus-visible:ring-4 focus-visible:ring-white/30" data-hero-cta2>
                <span class="flex items-center gap-1.5 sm:gap-3">
                    <i data-lucide="message-circle" class="w-4 h-4 sm:w-5 sm:h-5"></i>
                    <span data-hero-cta2-text><?php echo t('hero.secondary_cta'); ?></span>
                    <i data-lucide="arrow-right" class="w-4 h-4 sm:w-5 sm:h-5"></i>
                </span>
            </a>
        </div>
        <div class="mt-5 sm:mt-6 lg:mt-8 flex justify-center gap-2 sm:gap-3" data-hero-indicators>
            <?php foreach ($heroSlides as $i => $_): ?>
                <button data-idx="<?php echo $i; ?>" class="group relative w-2.5 h-2.5 sm:w-3 sm:h-3 rounded-full bg-white/30 hover:bg-white/60 transition-all duration-300 ease-out focus:outline-none focus-visible:ring-2 focus-visible:ring-white/50">
                    <div class="absolute inset-0 rounded-full bg-white scale-0 group-hover:scale-100 transition-transform duration-300 ease-out"></div>
                    <!-- Glow effect for active state -->
                    <div class="absolute inset-0 rounded-full bg-white/20 scale-0 group-hover:scale-150 transition-transform duration-300 ease-out"></div>
                </button>
            <?php endforeach; ?>
        </div>
    </div>
    
    <!-- Curved Bottom Shape -->
    <div class="absolute bottom-0 left-0 w-full h-16 sm:h-20 md:h-24 overflow-hidden">
        <svg id="hero-curve" class="absolute bottom-0 left-0 w-full h-full" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M0,0 L0,120 L1200,120 L1200,0 Q600,100 0,0 Z" fill="white" />
        </svg>
    </div>
</section>




