<?php
require_once __DIR__ . '/utils.php';
// Shared header include
// Use utility language detection and switch URLs
$i18n = detect_lang();
$lang = $i18n['lang'];
$langPrefix = $i18n['prefix'];
$switchToAr = $i18n['switchToAr'];
$switchToEn = $i18n['switchToEn'];

// Auto-redirect to 404 for non-existent pages
auto_404_redirect();
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $lang === 'ar' ? 'rtl' : 'ltr'; ?>">
<head>
    <?php start_global_prefix_rewrite(); ?>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle : 'Altoukhi'; ?></title>
    <meta name="description" content="<?php echo isset($pageDescription) ? $pageDescription : 'Altoukhi Contracting - Specialists in construction and general contracting'; ?>">
    <link href="/assets/css/tailwind.css" rel="stylesheet">
    <link rel="icon" type="image/svg+xml" href="<?php echo compute_base_prefix(); ?>/assets/img/logo.svg">
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <style>
        html, body {
            scroll-behavior: smooth !important;
        }
        * {
            scroll-behavior: smooth !important;
        }
        a[href^="#"] {
            scroll-behavior: smooth !important;
        }
    </style>
</head>
<body dir="<?php echo $lang === 'ar' ? 'rtl' : 'ltr'; ?>" class="font-arabic bg-gray-50">
    <?php 
        $reqPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
        $basePrefix = compute_base_prefix();
        $path = ($basePrefix !== '' && (strpos($reqPath, $basePrefix . '/') === 0 || $reqPath === $basePrefix))
            ? substr($reqPath, strlen($basePrefix)) : $reqPath;
        if ($path === '') { $path = '/'; }
        $isHome = (($activePage ?? '') === 'home') || in_array($path, [
            '/', '/index.php', '/en', '/en/', '/en/index.php', '/ar', '/ar/', '/ar/index.php'
        ], true);
    ?>
    <header id="site-header" data-force-solid="<?php echo $isHome ? 'false' : 'true'; ?>" class="<?php echo $isHome
        ? 'fixed top-0 left-0 w-full z-50 transition-all duration-300 bg-transparent text-white'
        : 'bg-white/90 backdrop-blur sticky top-0 z-50 border-b border-gray-100 text-black'; ?>">
        <div class="relative">
            <div id="header-info" class="hidden lg:block">
                <div class="bg-[var(--color-primary-600)] text-white relative overflow-hidden">
                    <svg aria-hidden="true" class="pointer-events-none absolute -top-10 -left-10 w-[420px] h-[420px] opacity-20" viewBox="0 0 200 200" fill="none">
                        <defs>
                            <linearGradient id="g1" x1="0" y1="0" x2="1" y2="1">
                                <stop offset="0%" stop-color="white" stop-opacity="0.6" />
                                <stop offset="100%" stop-color="white" stop-opacity="0.1" />
                            </linearGradient>
                        </defs>
                        <circle cx="0" cy="0" r="160" fill="url(#g1)" />
                        <path d="M0 0 L200 0" stroke="white" stroke-opacity="0.08" />
                        <path d="M0 20 L200 20" stroke="white" stroke-opacity="0.06" />
                        <path d="M0 40 L200 40" stroke="white" stroke-opacity="0.05" />
                    </svg>
                    <!-- Mirrored Decorative SVG on the right side -->
                    <svg aria-hidden="true" class="pointer-events-none absolute -top-10 -right-10 w-[420px] h-[420px] opacity-20" viewBox="0 0 200 200" fill="none">
                        <defs>
                            <linearGradient id="g2" x1="1" y1="0" x2="0" y2="1">
                                <stop offset="0%" stop-color="white" stop-opacity="0.6" />
                                <stop offset="100%" stop-color="white" stop-opacity="0.1" />
                            </linearGradient>
                        </defs>
                        <circle cx="200" cy="0" r="160" fill="url(#g2)" />
                        <path d="M0 0 L200 0" stroke="white" stroke-opacity="0.08" />
                        <path d="M0 20 L200 20" stroke="white" stroke-opacity="0.06" />
                        <path d="M0 40 L200 40" stroke="white" stroke-opacity="0.05" />
                    </svg>
                    <div class="container mx-auto px-4">
                        <div class="flex items-center gap-0 text-sm py-2">
                            <!-- left: info + phone -->
                            <div class="flex items-center gap-6 justify-start px-3 shrink-0">
                                <span class="inline-flex items-center gap-2">
                                    <i data-lucide="map-pin-plus" class="w-5 h-5 info-icon"></i>
                                    <span class="info-sub"><?php echo t('header.location_address'); ?></span>
                                </span>
                                <span class="hidden md:inline-flex items-center gap-2">
                                    <i data-lucide="calendar-clock" class="w-5 h-5 info-icon"></i>
                                    <span class="info-sub"><?php echo t('header.hours_value'); ?></span>
                                </span>
                                <a href="tel:+966112766655" class="inline-flex items-center gap-2 hover:opacity-90">
                                    <i data-lucide="phone-call" class="w-5 h-5 info-icon"></i>
                                    <span class="info-sub text-white/70">011 2766655</span>
                                </a>
                            </div>
                            <!-- center: search -->
                            <div class="flex-1 flex items-center justify-center px-3">
                                <form action="<?php echo $langPrefix; ?>/search.php" method="get" class="w-full max-w-md">
                                    <div class="relative">
                                        <input type="text" name="q" placeholder="<?php echo $lang==='ar' ? 'ابحث...' : 'Search...'; ?>" class="w-full <?php echo $lang==='ar' ? 'pr-9 pl-3' : 'pl-9 pr-3'; ?> py-2 rounded-md bg-white/10 text-white placeholder-white/70 ring-1 ring-white/20 focus:outline-none focus:ring-primary-300" />
                                        <svg class="absolute <?php echo $lang==='ar' ? 'right-2' : 'left-2'; ?> top-1/2 -translate-y-1/2 w-4 h-4 text-white/80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
                    </div>
                                </form>
                </div>
                            <!-- right: social (language is separate sibling) -->
                            <div class="hidden md:grid grid-flow-col auto-cols-max gap-2 px-3">
                                <a href="<?php echo htmlspecialchars($switchToAr); ?>" class="px-2 py-1 rounded-md ring-1 ring-white/30 <?php echo $lang==='ar' ? 'bg-white/20' : 'bg-white/10'; ?>">AR</a>
                                <a href="<?php echo htmlspecialchars($switchToEn); ?>" class="px-2 py-1 rounded-md ring-1 ring-white/30 <?php echo $lang==='en' ? 'bg-white/20' : 'bg-white/10'; ?>">EN</a>
                            </div>
                            <div class="flex items-center justify-end gap-4 px-3">
                                    <a aria-label="whatsapp" href="https://wa.me/966112766655" class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-white/10 ring-1 ring-white/10 hover:bg-white/20 transition">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" class="w-5 h-5 text-white" fill="currentColor" aria-hidden="true">
                                            <path d="M26.576 5.363c-2.69-2.69-6.406-4.354-10.511-4.354-8.209 0-14.865 6.655-14.865 14.865 0 2.732 0.737 5.291 2.022 7.491l-0.038-0.070-2.109 7.702 7.879-2.067c2.051 1.139 4.498 1.809 7.102 1.809h0.006c8.209-0.003 14.862-6.659 14.862-14.868 0-4.103-1.662-7.817-4.349-10.507l0 0zM16.062 28.228h-0.005c-0 0-0.001 0-0.001 0-2.319 0-4.489-0.64-6.342-1.753l0.056 0.031-0.451-0.267-4.675 1.227 1.247-4.559-0.294-0.467c-1.185-1.862-1.889-4.131-1.889-6.565 0-6.822 5.531-12.353 12.353-12.353s12.353 5.531 12.353 12.353c0 6.822-5.53 12.353-12.353 12.353h-0zM22.838 18.977c-0.371-0.186-2.197-1.083-2.537-1.208-0.341-0.124-0.589-0.185-0.837 0.187-0.246 0.371-0.958 1.207-1.175 1.455-0.216 0.249-0.434 0.279-0.805 0.094-1.15-0.466-2.138-1.087-2.997-1.852l0.010 0.009c-0.799-0.74-1.484-1.587-2.037-2.521l-0.028-0.052c-0.216-0.371-0.023-0.572 0.162-0.757 0.167-0.166 0.372-0.434 0.557-0.65 0.146-0.179 0.271-0.384 0.366-0.604l0.006-0.017c0.043-0.087 0.068-0.188 0.068-0.296 0-0.131-0.037-0.253-0.101-0.357l0.002 0.003c-0.094-0.186-0.836-2.014-1.145-2.758-0.302-0.724-0.609-0.625-0.836-0.637-0.216-0.010-0.464-0.012-0.712-0.012-0.395 0.010-0.746 0.188-0.988 0.463l-0.001 0.002c-0.802 0.761-1.3 1.834-1.3 3.023 0 0.026 0 0.053 0.001 0.079l-0-0.004c0.131 1.467 0.681 2.784 1.527 3.857l-0.012-0.015c1.604 2.379 3.742 4.282 6.251 5.564l0.094 0.043c0.548 0.248 1.25 0.513 1.968 0.74l0.149 0.041c0.442 0.14 0.951 0.221 1.479 0.221 0.303 0 0.601-0.027 0.889-0.078l-0.031 0.004c1.069-0.223 1.956-0.868 2.497-1.749l0.009-0.017c0.165-0.366 0.261-0.793 0.261-1.242 0-0.185-0.016-0.366-0.047-0.542l0.003 0.019c-0.092-0.155-0.34-0.247-0.712-0.434z"/>
                                        </svg>
                                    </a>
                                    <a aria-label="x" href="#" class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-white/10 ring-1 ring-white/10 hover:bg-white/20 transition"><i data-lucide="x" class="w-5 h-5 info-icon"></i></a>
                                    <a aria-label="linkedin" href="#" class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-white/10 ring-1 ring-white/10 hover:bg-white/20 transition"><i data-lucide="linkedin" class="w-5 h-5 info-icon"></i></a>
                                    <a aria-label="facebook" href="#" class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-white/10 ring-1 ring-white/10 hover:bg-white/20 transition"><i data-lucide="facebook" class="w-5 h-5 info-icon"></i></a>
                                </div>
                    </div>
                </div>
                    </div>
                </div>
            </div>
        <div class="container mx-auto px-4 py-1 lg:py-2 fade-in-down">

            <div class="grid grid-cols-[auto_1fr_auto] items-center gap-3 lg:gap-6 py-1 lg:py-2">
                <div class="flex items-center gap-3 lg:gap-4">
                    <a href="<?php echo $langPrefix; ?>/index.php" aria-label="Altoukhi Home" class="inline-flex items-center">
                        <img src="/assets/img/logo.svg" alt="company logo" class="h-9 lg:h-12 w-auto object-contain" />
                    </a>
                </div>
                <div class="hidden lg:flex justify-center">
                    <div id="site-header-links" class="flex gap-8 xl:gap-10 text-base xl:text-lg">
                        <a href="<?php echo $langPrefix; ?>/index.php" class="link-underline px-2 py-2 rounded-md transition duration-200 text-current <?php echo ($activePage==='home') ? 'font-semibold' : ''; ?>"><?php echo t('nav.home'); ?></a>
                        
                        <!-- About Us Mega Menu -->
                        <div class="group">
                            <a href="#" class="link-underline px-2 py-2 rounded-md transition duration-200 text-current <?php echo ($activePage==='about') ? 'font-semibold' : ''; ?> flex items-center gap-1">
                                <?php echo t('nav.about'); ?>
                                <svg class="w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </a>
                            <div class="mega-menu-full absolute top-full bg-white/95 backdrop-blur-sm rounded-2xl shadow-2xl border border-gray-100 opacity-0 -translate-y-[100vh] invisible transition-[transform,opacity] duration-500 md:duration-600 ease-[cubic-bezier(0.22,1,0.36,1)] will-change-[transform,opacity] motion-reduce:transition-none motion-reduce:transform-none z-50 overflow-hidden">
                                <div class="px-8 py-8 text-white relative overflow-hidden" style="background: linear-gradient(135deg, #342e87 0%, #2a2570 50%, #1f1a5a 100%);">
                                    <div class="absolute top-0 right-0 w-32 h-32 bg-white/10 rounded-full -translate-y-16 translate-x-16"></div>
                                    <div class="absolute bottom-0 left-0 w-24 h-24 bg-white/5 rounded-full translate-y-12 -translate-x-12"></div>
                                    
                                    <div class="relative z-10 text-center">
                                        <h2 class="text-3xl font-bold mb-3 text-white"><?php echo t('megamenu.about.title'); ?></h2>
                                        <p class="text-white/90 text-base leading-relaxed"><?php echo t('megamenu.about.subtitle'); ?></p>
                                    </div>
                                </div>
                                
                                <div class="p-10 max-w-7xl mx-auto opacity-0 translate-y-4 transition-all duration-500 delay-100 group-hover:opacity-100 group-hover:translate-y-0">
                                    <div class="grid grid-cols-4 gap-8">
                                        <!-- Who Are We -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.about.who_are_we'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/about.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.who_are_we'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <!-- Leadership Team -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.about.leadership_team'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/about.php#chairman" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.chairman'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/about.php#executive-team" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.executive_team'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/about.php#contributors" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.contributors'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <!-- Certificates & Employment -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.about.certificates_employment'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/certificates.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.certificates'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/clients.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.customers'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/career.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-primary-600 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('megamenu.about.employment'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-all duration-300 group">
                                            <div class="p-6 text-white" style="background: linear-gradient(135deg, #342e87 0%, #2a2570 100%);">
                                                <div class="flex items-center gap-3 mb-4">
                                                    <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center backdrop-blur-sm">
                                                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                        </svg>
                                                    </div>
                                                    <h3 class="font-bold text-xl"><?php echo t('megamenu.about.how_can_help'); ?></h3>
                                                </div>
                                                <p class="text-white/90 text-sm leading-relaxed">
                                                    <?php echo t('megamenu.about.company_description'); ?>
                                                </p>
                                            </div>
                                            <div class="p-6">
                                                <a href="<?php echo $langPrefix; ?>/contact.php" class="inline-flex items-center gap-2 font-semibold text-sm px-4 py-2 rounded-lg transition-all duration-200" style="color: #342e87; background-color: rgba(52, 46, 135, 0.1);" onmouseover="this.style.backgroundColor='rgba(52, 46, 135, 0.2)'" onmouseout="this.style.backgroundColor='rgba(52, 46, 135, 0.1)'">
                                                    <?php echo t('megamenu.about.contact_us'); ?>
                                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Projects Mega Menu -->
                        <div class="group">
                            <a href="#" class="link-underline px-2 py-2 rounded-md transition duration-200 text-current <?php echo ($activePage==='projects') ? 'font-semibold' : ''; ?> flex items-center gap-1">
                                <?php echo t('nav.projects'); ?>
                                <svg class="w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </a>
                            <div class="mega-menu-full absolute top-full bg-white/95 backdrop-blur-sm rounded-2xl shadow-2xl border border-gray-100 opacity-0 -translate-y-[100vh] invisible transition-[transform,opacity] duration-500 md:duration-600 ease-[cubic-bezier(0.22,1,0.36,1)] will-change-[transform,opacity] motion-reduce:transition-none motion-reduce:transform-none z-50 overflow-hidden">
                                <div class="px-8 py-8 text-white relative overflow-hidden" style="background: linear-gradient(135deg, #342e87 0%, #2a2570 50%, #1f1a5a 100%);">
                                    <div class="absolute top-0 left-0 w-32 h-32 bg-white/10 rounded-full -translate-y-16 -translate-x-16"></div>
                                    <div class="absolute bottom-0 right-0 w-24 h-24 bg-white/5 rounded-full translate-y-12 translate-x-12"></div>
                                    
                                    <div class="relative z-10 text-center">
                                        <h2 class="text-3xl font-bold mb-3 text-white"><?php echo t('megamenu.projects.title'); ?></h2>
                                        <p class="text-white/90 text-base leading-relaxed"><?php echo t('megamenu.projects.subtitle'); ?></p>
                                    </div>
                                </div>
                                
                                <div class="p-10 max-w-7xl mx-auto opacity-0 translate-y-4 transition-all duration-500 delay-100 group-hover:opacity-100 group-hover:translate-y-0">
                                    <div class="grid grid-cols-5 gap-8">
                                        <!-- Power Generation -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.projects.power_generation'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/projects/power-generation.php#simple-cycle" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-yellow-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.power_generation.simple_cycle.title'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <!-- Power Transmission -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.projects.power_transmission'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/projects/power-transmission.php#overhead-lines" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-blue-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.power_transmission.overhead_lines.title'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/projects/power-transmission.php#substations" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-blue-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.power_transmission.substations.title'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/projects/power-transmission.php#underground-cables" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-blue-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.power_transmission.underground_cables.title'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/projects/all-projects.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-blue-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.general.all_projects'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <!-- Cooling Systems -->
                                        <div class="space-y-4">
                                            <div class="flex items-center gap-3 mb-4">
                                                <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center">
                                                    <svg class="w-5 h-5 text-cyan-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                                    </svg>
                                                </div>
                                                <h3 class="font-bold text-gray-900 text-lg"><?php echo t('megamenu.projects.cooling_systems'); ?></h3>
                                            </div>
                                            <ul class="space-y-3">
                                                <li><a href="<?php echo $langPrefix; ?>/projects/cooling.php#cooling-solutions" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-cyan-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.cooling.section1.title'); ?></span>
                                                </a></li>
                                                <li><a href="<?php echo $langPrefix; ?>/projects/all-projects.php" class="flex items-center gap-3 text-gray-700 hover:text-primary-600 transition-all duration-200 group">
                                                    <div class="w-2 h-2 bg-cyan-500 rounded-full group-hover:scale-125 transition-transform"></div>
                                                    <span class="font-medium text-sm"><?php echo t('projects_pages.general.all_projects'); ?></span>
                                                </a></li>
                                            </ul>
                                        </div>

                                        <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-6">
                                            <h3 class="font-bold text-gray-900 text-lg mb-4"><?php echo t('megamenu.projects.current_projects'); ?></h3>
                                            <div class="space-y-4">
                                                <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#ongoing-projects" class="block bg-white rounded-lg p-4 shadow-sm hover:shadow-md transition">
                                                    <h4 class="font-semibold text-gray-900 text-sm mb-1"><?php echo t('projects_pages.power_transmission.khamis_mushayat'); ?></h4>
                                                    <p class="text-gray-600 text-xs"><?php echo t('projects_pages.general.power_transmission'); ?> · Nov 2015 → Apr 2018</p>
                                                </a>
                                                <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#ongoing-projects" class="block bg-white rounded-lg p-4 shadow-sm hover:shadow-md transition">
                                                    <h4 class="font-semibold text-gray-900 text-sm mb-1"><?php echo t('projects_pages.power_transmission.al_waha'); ?></h4>
                                                    <p class="text-gray-600 text-xs"><?php echo t('projects_pages.general.power_transmission'); ?> · Mar 2015 → Aug 2017</p>
                                                </a>
                                            </div>
                                            <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#ongoing-projects" class="mt-4 inline-flex items-center gap-2 text-green-600 hover:text-green-700 font-medium text-sm">
                                                <?php echo t('megamenu.projects.view_all'); ?>
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                </svg>
                                            </a>
                                        </div>

                                        <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl p-6">
                                            <h3 class="font-bold text-gray-900 text-lg mb-4"><?php echo t('megamenu.projects.featured_projects'); ?></h3>
                                            <div class="space-y-4">
                                                <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#completed-projects" class="block bg-white rounded-lg p-4 shadow-sm hover:shadow-md transition">
                                                    <h4 class="font-semibold text-gray-900 text-sm mb-1"><?php echo t('projects_pages.power_transmission.substation_8102'); ?></h4>
                                                    <p class="text-gray-600 text-xs"><?php echo t('projects_pages.general.power_transmission'); ?> · May 2002 → May 2004</p>
                                                </a>
                                                <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#completed-projects" class="block bg-white rounded-lg p-4 shadow-sm hover:shadow-md transition">
                                                    <h4 class="font-semibold text-gray-900 text-sm mb-1"><?php echo t('projects_pages.power_transmission.al_dhahiyah'); ?></h4>
                                                    <p class="text-gray-600 text-xs"><?php echo t('projects_pages.general.power_transmission'); ?> · May 2006 → Dec 2009</p>
                                                </a>
                                            </div>
                                            <a href="<?php echo $langPrefix; ?>/projects/all-projects.php#completed-projects" class="mt-4 inline-flex items-center gap-2 text-blue-600 hover:text-blue-700 font-medium text-sm">
                                                <?php echo t('megamenu.projects.view_all'); ?>
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <a href="<?php echo $langPrefix; ?>/career.php" class="link-underline px-2 py-2 rounded-md transition duration-200 text-current <?php echo ($activePage==='career') ? 'font-semibold' : ''; ?>"><?php echo t('nav.career'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/contact.php" class="link-underline px-2 py-2 rounded-md transition duration-200 text-current <?php echo ($activePage==='contact') ? 'font-semibold' : ''; ?>"><?php echo t('nav.contact'); ?></a>
                    </div>
                </div>
                <div class="hidden lg:flex items-center gap-3 justify-end">
                    <a href="tel:+966112766655" class="px-3 py-2 rounded-md ring-1 ring-current/40 text-current hover:bg-white/10 transition-colors"><?php echo t('nav.call_now'); ?></a>
                    <a href="<?php echo $langPrefix; ?>/contact.php" class="px-3 py-2 rounded-md font-semibold bg-primary-600 text-white hover:bg-primary-700 transition-colors"><?php echo t('nav.cta_quote'); ?></a>
                </div>
                <div class="lg:hidden flex items-center justify-end">
                    <button id="mobileMenuBtn" class="text-current" aria-label="Menu" aria-controls="mobile-nav" aria-expanded="false">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                    </button>
                </div>
            </div>
        </div>
        </div>
        
    </header>

    <!-- Mobile Navigation  -->
    <nav id="mobile-nav" class="md:hidden hidden fixed inset-0 w-screen h-dvh overflow-hidden z-[99999]" aria-hidden="true">
        <div id="mobileBackdrop" class="fixed inset-0 bg-black/60 opacity-0 transition-opacity duration-300 z-[99999]" role="presentation" aria-hidden="true"></div>
        <!-- Panel -->
        <div id="mobilePanel" class="fixed top-0 bottom-0 rtl:right-0 ltr:left-0 w-[88%] max-w-sm h-dvh bg-white text-black shadow-2xl overflow-y-auto transform transition-transform duration-300 ease-out ltr:-translate-x-full rtl:translate-x-full will-change-transform z-[100000]" role="dialog" aria-modal="true" aria-labelledby="mobileNavTitle" tabindex="-1">
            <div class="flex items-center justify-between px-4 py-3 border-b border-gray-100">
                <div class="flex items-center gap-2">
                    <a href="<?php echo $langPrefix; ?>/index.php" aria-label="Altoukhi Home" class="inline-flex items-center">
                        <img src="/assets/img/logo.svg" alt="company logo" class="h-9 w-auto object-contain" />
                    </a>
                    
                </div>
                <button id="mobileCloseBtn" class="p-2 rounded-md hover:bg-gray-100" aria-label="Close Menu">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                </button>
            </div>

            <div class="px-4 py-4 space-y-1 rtl:text-right ltr:text-left">
                <a href="<?php echo $langPrefix; ?>/index.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('nav.home'); ?></a>

                <!-- About accordion -->
                <details class="group">
                    <summary class="flex items-center justify-between px-3 py-2 rounded-md cursor-pointer hover:bg-gray-50">
                        <span class="text-black"><?php echo t('nav.about'); ?></span>
                        <svg class="w-4 h-4 text-gray-500 group-open:rotate-180 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </summary>
                    <div class="pl-4 pr-3 py-2 space-y-1">
                        <a href="<?php echo $langPrefix; ?>/about.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.about.who_are_we'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/about.php#executive-team" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.about.executive_team'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/certificates.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.about.certificates'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/clients.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.about.customers'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/career.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.about.employment'); ?></a>
                    </div>
                </details>

                <!-- Projects accordion -->
                <details class="group">
                    <summary class="flex items-center justify-between px-3 py-2 rounded-md cursor-pointer hover:bg-gray-50">
                        <span class="text-black"><?php echo t('nav.projects'); ?></span>
                        <svg class="w-4 h-4 text-gray-500 group-open:rotate-180 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    </summary>
                    <div class="pl-4 pr-3 py-2 space-y-1">
                        <a href="<?php echo $langPrefix; ?>/projects/power-generation.php#simple-cycle" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.projects.power_generation'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/projects/power-transmission.php#overhead-lines" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.projects.power_transmission'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/projects/cooling.php#cooling-solutions" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('megamenu.projects.cooling_systems'); ?></a>
                        <a href="<?php echo $langPrefix; ?>/projects/all-projects.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('projects_pages.general.all_projects'); ?></a>
                    </div>
                </details>

                <a href="<?php echo $langPrefix; ?>/career.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('nav.career'); ?></a>
                <a href="<?php echo $langPrefix; ?>/contact.php" class="block px-3 py-2 rounded-md text-black hover:bg-gray-50"><?php echo t('nav.contact'); ?></a>
            
                <!-- Language Switch -->
                <div class="mt-3 px-3 py-2 border-t border-gray-100 flex items-center gap-2">
                    <a href="<?php echo htmlspecialchars($switchToAr); ?>" class="px-2 py-1 rounded-md ring-1 ring-gray-300 <?php echo $lang==='ar' ? 'bg-gray-100' : ''; ?>">AR</a>
                    <a href="<?php echo htmlspecialchars($switchToEn); ?>" class="px-2 py-1 rounded-md ring-1 ring-gray-300 <?php echo $lang==='en' ? 'bg-gray-100' : ''; ?>">EN</a>
                </div>

                <!-- Quick contact -->
                <div class="mt-2 px-3 py-3">
                    <a href="tel:+966112766655" class="w-full inline-flex items-center justify-center gap-2 px-4 py-2 rounded-md ring-1 ring-primary-600 text-primary-700 hover:bg-primary-50"><?php echo t('nav.call_now'); ?></a>
                    <a href="<?php echo $langPrefix; ?>/contact.php" class="w-full mt-2 inline-flex items-center justify-center gap-2 px-4 py-2 rounded-md bg-primary-600 text-white hover:bg-primary-700"><?php echo t('nav.cta_quote'); ?></a>
                </div>
            </div>
        </div>
    </nav>
<script>
    (function() {
        const btn = document.getElementById('mobileMenuBtn');
        const nav = document.getElementById('mobile-nav');
        const panel = document.getElementById('mobilePanel');
        const closeBtn = document.getElementById('mobileCloseBtn');
        const backdrop = document.getElementById('mobileBackdrop');
        if (!btn || !nav) return;

        function openNav() {
            nav.classList.remove('hidden');
            nav.setAttribute('aria-hidden', 'false');
            requestAnimationFrame(() => {
                backdrop && backdrop.classList.add('opacity-100');
                if (panel) {
                    panel.classList.remove('ltr:-translate-x-full', 'rtl:translate-x-full');
                    panel.classList.add('translate-x-0');
                    panel.focus();
                }
            });
            btn.setAttribute('aria-expanded', 'true');
            // Lock scroll on html and body to defeat page-level CSS
            document.documentElement.classList.add('overflow-hidden');
            document.body.classList.add('overflow-hidden');
        }
        function closeNav() {
            backdrop && backdrop.classList.remove('opacity-100');
            if (panel) {
                panel.classList.add('ltr:-translate-x-full', 'rtl:translate-x-full');
                panel.classList.remove('translate-x-0');
            }
            setTimeout(() => { nav.classList.add('hidden'); }, 280);
            btn.setAttribute('aria-expanded', 'false');
            nav.setAttribute('aria-hidden', 'true');
            document.documentElement.classList.remove('overflow-hidden');
            document.body.classList.remove('overflow-hidden');
        }

        btn.addEventListener('click', openNav);
        if (closeBtn) closeBtn.addEventListener('click', closeNav);
        if (backdrop) backdrop.addEventListener('click', closeNav);
        // Close on Esc or any link click inside panel
        document.addEventListener('keydown', function(e){ if (e.key === 'Escape') closeNav(); });
        panel && panel.addEventListener('click', function(e){
            var t = e.target;
            if (!t) return;
            if (t.closest && t.closest('a')) closeNav();
        });
    })();
    window.addEventListener('DOMContentLoaded', () => { if (window.lucide) lucide.createIcons(); });
	// Hover-intent mega menu: open on hover, keep open while over header or menu, close only when fully outside
	(function(){
		var header = document.getElementById('site-header');
		if (!header) return;
		var nav = document.getElementById('site-header-nav');
		var info = document.getElementById('header-info');
		var logoImg = header ? header.querySelector('img[src$="logo.svg"]') : null;
		var forceSolid = header.getAttribute('data-force-solid') === 'true';
		var groups = document.querySelectorAll('#site-header-links > .group');
		var currentOpen = null;
		var openTimer = null;
		var closeTimer = null;
		var OPEN_DELAY = 120; // ms
		var CLOSE_DELAY = 280; // ms

		// Utility helpers for cleaner, more maintainable code
		var CLS_OPEN = ['opacity-100','visible','translate-y-0'];
		var CLS_CLOSED = ['opacity-0','invisible','-translate-y-[100vh]'];
		function addClasses(el, arr){ arr.forEach(function(c){ el.classList.add(c); }); }
		function removeClasses(el, arr){ arr.forEach(function(c){ el.classList.remove(c); }); }
		function isAnyMenuOpen(){
			return Array.prototype.some.call(document.querySelectorAll('.mega-menu-full'), function(mm){
				return CLS_OPEN.every(function(c){ return mm.classList.contains(c); });
			});
		}
		function isPointerInsideHeaderOrMenus(){
			if (header.matches(':hover')) return true;
			var any = false;
			Array.prototype.forEach.call(document.querySelectorAll('.mega-menu-full'), function(mm){ if (mm.matches(':hover')) any = true; });
			return any;
		}

		function getOverlay(){
			var el = document.getElementById('mega-overlay');
			if (!el) {
				el = document.createElement('div');
				el.id = 'mega-overlay';
				el.className = 'fixed inset-0 bg-black/40 opacity-0 transition-opacity duration-200 pointer-events-none';
				document.body.appendChild(el);
			}
			return el;
		}
		function showOverlay(){
			var el = getOverlay();
			el.classList.remove('opacity-0','pointer-events-none');
			el.classList.add('opacity-100');
		}
		function hideOverlay(){
			var el = document.getElementById('mega-overlay');
			if (!el) return;
			el.classList.add('opacity-0','pointer-events-none');
			el.classList.remove('opacity-100');
		}

		function setHeaderSolid(){
			header.classList.remove('bg-transparent','text-white');
			header.classList.add('bg-white/90','backdrop-blur','text-black','shadow-md');
			if (logoImg) logoImg.style.filter = '';
			if (nav) { nav.classList.remove('bg-transparent'); nav.classList.add('bg-white'); }
			if (info) {
				info.querySelectorAll('.info-title').forEach(function(el){ el.classList.remove('text-white/90'); el.classList.add('text-gray-800'); });
				info.querySelectorAll('.info-icon').forEach(function(el){ el.classList.remove('text-white/80'); });
			}
		}
		function setHeaderTransparent(){
			header.classList.add('bg-transparent','text-white');
			header.classList.remove('bg-white','bg-white/90','text-black','shadow-md','backdrop-blur');
			if (logoImg) logoImg.style.filter = 'brightness(0) invert(1)';
			if (nav) { nav.classList.add('bg-transparent'); nav.classList.remove('bg-white'); }
			if (info) {
				info.querySelectorAll('.info-title').forEach(function(el){ el.classList.remove('text-gray-800'); el.classList.add('text-white/90'); });
				info.querySelectorAll('.info-icon').forEach(function(el){ el.classList.add('text-white/80'); });
			}
		}

		function cancelTimers(){
			if (openTimer) { clearTimeout(openTimer); openTimer = null; }
			if (closeTimer) { clearTimeout(closeTimer); closeTimer = null; }
		}

	function applyOpenStyles(group){
		var trigger = group.querySelector(':scope > a');
		var menu = group.querySelector(':scope > .mega-menu-full');
		if (!trigger || !menu) return;
		if (currentOpen && currentOpen !== group) {
			clearOpenStyles(currentOpen);
		}
	currentOpen = group;
	removeClasses(menu, CLS_CLOSED);
	addClasses(menu, CLS_OPEN);
		var inner = menu.querySelector('.p-10');
	if (inner) { removeClasses(inner, ['opacity-0','translate-y-4']); addClasses(inner, ['opacity-100','translate-y-0']); }
		var icon = trigger.querySelector('svg');
		if (icon) icon.style.transform = 'rotate(180deg)';
		trigger.setAttribute('aria-expanded','true');
		// Ensure header adopts solid style while menu is open
		setHeaderSolid();
		// Global flag so other scripts (e.g., scroll) do not override while open
		document.documentElement.classList.add('mega-open');
		// Show body overlay
		showOverlay();
	}

	function clearOpenStyles(group){
		var trigger = group.querySelector(':scope > a');
		var menu = group.querySelector(':scope > .mega-menu-full');
		if (!trigger || !menu) return;
	addClasses(menu, CLS_CLOSED);
	removeClasses(menu, CLS_OPEN);
		var inner = menu.querySelector('.p-10');
	if (inner) { addClasses(inner, ['opacity-0','translate-y-4']); removeClasses(inner, ['opacity-100','translate-y-0']); }
		var icon = trigger.querySelector('svg');
		if (icon) icon.style.transform = '';
		trigger.setAttribute('aria-expanded','false');
		if (currentOpen === group) currentOpen = null;
		// Restore header style based on rules once menu closes
		if (forceSolid) { setHeaderSolid(); }
		else if (window.scrollY > 50) { setHeaderSolid(); } else { setHeaderTransparent(); }
		// If no menus are open, remove the global flag
		var anyOpen = false;
		document.querySelectorAll('.mega-menu-full').forEach(function(mm){
			if (mm.classList.contains('opacity-100') && mm.classList.contains('visible') && mm.classList.contains('translate-y-0')) anyOpen = true;
		});
		if (!anyOpen) {
			document.documentElement.classList.remove('mega-open');
			hideOverlay();
			// Ensure final header state respects forceSolid on non-home pages
			if (forceSolid) { setHeaderSolid(); }
		}
	}

		function scheduleOpen(group){
			if (openTimer) { clearTimeout(openTimer); openTimer = null; }
			openTimer = setTimeout(function(){ applyOpenStyles(group); }, OPEN_DELAY);
		}

		function scheduleClose(){
			if (closeTimer) { clearTimeout(closeTimer); closeTimer = null; }
			closeTimer = setTimeout(function(){
				if (!currentOpen) return;
				if (!isPointerInsideHeaderOrMenus()) {
					clearOpenStyles(currentOpen);
				}
			}, CLOSE_DELAY);
		}

	function bindGroup(group){
		var trigger = group.querySelector(':scope > a');
		var menu = group.querySelector(':scope > .mega-menu-full');
		if (!trigger || !menu) return;
		trigger.setAttribute('aria-haspopup','true');

		// Open when entering the entire group area (not just the link)
		group.addEventListener('mouseenter', function(){ cancelTimers(); scheduleOpen(group); });
		group.addEventListener('mouseleave', function(e){
			var to = e.relatedTarget;
			if (to && (to.closest && (to.closest('#site-header') || group.contains(to)))) return;
			scheduleClose();
		});
		// Ensure moving into menu keeps it open
		menu.addEventListener('mouseenter', function(){ cancelTimers(); });
		menu.addEventListener('mouseleave', function(){ scheduleClose(); });
	}

		groups.forEach(bindGroup);

		header.addEventListener('mouseenter', function(){ cancelTimers(); });
		header.addEventListener('mouseleave', function(e){
			var to = e.relatedTarget;
			if (to && (to.closest && (to.closest('#site-header') || to.closest('.mega-menu-full')))) return;
			scheduleClose();
		});
		document.addEventListener('keydown', function(e){ if (e.key === 'Escape' && currentOpen) { clearOpenStyles(currentOpen); } });
	})();
</script>
