<?php $basePrefix = compute_base_prefix(); ?>
<footer class="relative bg-gray-900 text-white overflow-hidden">
        <!-- background SVG for footer -->
        <div class="absolute inset-0 bg-right bg-contain bg-no-repeat opacity-5" style="background-image: url('<?php echo $basePrefix; ?>/assets/img/arrow-bg.svg'); background-size: 50%; background-position: right bottom;"></div>
        
        <div class="container mx-auto px-4 py-6 md:py-8">
            <div class="bg-primary-600 rounded-2xl p-6 sm:p-10 md:p-20 text-center relative overflow-hidden">
                <div class="absolute inset-0 bg-cover bg-center bg-no-repeat opacity-20" style="background-image: url('<?php echo $basePrefix; ?>/assets/img/cta-footer/soldering-worker.png');"></div>
                
                <div class="absolute inset-0 bg-primary-600/60 rounded-2xl"></div>
                
                <div class="absolute inset-0 opacity-15 rounded-2xl">
                    <svg class="absolute top-0 left-0 w-full h-full rounded-2xl" viewBox="0 0 1200 400" preserveAspectRatio="none">
                        <!-- Geometric shapes -->
                        <polygon points="0,0 300,0 200,150 0,100" fill="white" opacity="0.1"/>
                        <polygon points="1200,0 900,0 1000,100 1200,150" fill="white" opacity="0.1"/>
                        <polygon points="0,400 200,400 100,300 0,350" fill="white" opacity="0.1"/>
                        <polygon points="1200,400 1000,400 1100,350 1200,300" fill="white" opacity="0.1"/>
                        
                        <!-- Central decorative elements -->
                        <rect x="500" y="50" width="200" height="100" fill="white" opacity="0.05" transform="rotate(45 600 100)"/>
                        <rect x="400" y="250" width="150" height="80" fill="white" opacity="0.05" transform="rotate(-30 475 290)"/>
                        <rect x="600" y="175" width="120" height="60" fill="white" opacity="0.04" transform="rotate(60 660 205)"/>
                    </svg>
                </div>
                
                <!-- Content -->
                <div class="relative">
                    <h3 class="text-2xl sm:text-3xl md:text-5xl font-bold mb-4 sm:mb-6 md:mb-8 leading-tight"><?php echo t('footer.cta_title'); ?></h3>
                    <a href="tel:0112766655" class="btn-asym inline-flex items-center justify-center px-5 py-3 sm:px-8 sm:py-4 md:px-12 md:py-5 font-semibold sm:font-bold text-base sm:text-lg md:text-xl text-primary-600 bg-white shadow-lg md:shadow-2xl hover:shadow-md md:hover:shadow-xl focus:outline-none focus-visible:ring-4 focus-visible:ring-white/30">
                        <span class="flex items-center gap-2 sm:gap-3">
                            <i data-lucide="phone" class="w-5 h-5 sm:w-6 sm:h-6"></i>
                            <span><?php echo t('footer.cta_button'); ?></span>
                            <i data-lucide="arrow-right" class="w-5 h-5 sm:w-6 sm:h-6"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
        <div class="pointer-events-none absolute inset-x-0 -top-px h-px bg-gradient-to-l from-primary-600/60 via-cyan-400/40 to-primary-600/60"></div>
        <div class="container mx-auto px-4 py-10 md:py-14">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-10">
                <div>
                    <div class="flex items-center gap-3 mb-4">
                        <img src="/assets/img/logo.svg" alt="Logo" class="h-10 w-auto" style="filter: brightness(0) invert(1);">
                    </div>
                    <p class="text-gray-400 leading-relaxed text-sm sm:text-base"><?php echo t('footer.about_blurb'); ?></p>
                </div>
                <div class="grid grid-cols-2 gap-4 sm:gap-6">
                    <div>
                        <h4 class="text-white/90 font-semibold mb-2 sm:mb-3 text-sm sm:text-base"><?php echo t('footer.quick_links'); ?></h4>
                        <ul class="space-y-1.5 sm:space-y-2 text-gray-400 text-sm sm:text-base">
                            <li><a class="hover:text-white transition-colors" href="/index.php"><?php echo t('nav.home'); ?></a></li>
                            <li><a class="hover:text-white transition-colors" href="/about.php"><?php echo t('nav.about'); ?></a></li>
                            <li><a class="hover:text-white transition-colors" href="/services.php"><?php echo t('nav.services'); ?></a></li>
                            <li><a class="hover:text-white transition-colors" href="/projects.php"><?php echo t('nav.projects'); ?></a></li>
                            <li><a class="hover:text-white transition-colors" href="/contact.php"><?php echo t('nav.contact'); ?></a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="text-white/90 font-semibold mb-2 sm:mb-3 text-sm sm:text-base"><?php echo t('footer.contact'); ?></h4>
                        <ul class="space-y-1.5 sm:space-y-2 text-gray-400 text-sm sm:text-base">
                            <li><a class="hover:text-white transition-colors" href="tel:0112766655">011 2766655</a></li>
                            <li><a class="hover:text-white transition-colors" href="mailto:information@altoukhi.com">information@altoukhi.com</a></li>
                            <li><?php echo t('footer.address'); ?></li>
                        </ul>
                        <div class="mt-4 flex items-center gap-2.5 sm:gap-3">
                            <a aria-label="twitter" class="h-8 w-8 sm:h-9 sm:w-9 rounded-full bg-white/10 hover:bg-white/20 grid place-items-center transition-colors" href="#">
                                <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" viewBox="0 0 24 24" fill="currentColor"><path d="M22.46 6c-.77.35-1.6.58-2.46.69a4.26 4.26 0 0 0 1.87-2.36 8.5 8.5 0 0 1-2.69 1.03A4.24 4.24 0 0 0 12 8.24c0 .33.04.65.1.95A12.04 12.04 0 0 1 3.16 4.9a4.24 4.24 0 0 0 1.31 5.66 4.2 4.2 0 0 1-1.92-.53v.05a4.24 4.24 0 0 0 3.4 4.16 4.3 4.3 0 0 1-1.91.07 4.25 4.25 0 0 0 3.97 2.95A8.5 8.5 0 0 1 2 19.54a12 12 0 0 0 6.5 1.9c7.8 0 12.07-6.46 12.07-12.07 0-.18 0-.36-.01-.54A8.62 8.62 0 0 0 22.46 6z"/></svg>
                            </a>
                            <a aria-label="linkedin" class="h-8 w-8 sm:h-9 sm:w-9 rounded-full bg-white/10 hover:bg-white/20 grid place-items-center transition-colors" href="#">
                                <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" viewBox="0 0 24 24" fill="currentColor"><path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1s2.48 1.12 2.48 2.5zM0 8h5v16H0V8zm7.5 0H12v2.2h.06c.63-1.2 2.16-2.46 4.44-2.46 4.75 0 5.62 3.13 5.62 7.2V24h-5v-6.67c0-1.59-.03-3.64-2.22-3.64-2.22 0-2.56 1.73-2.56 3.52V24h-5V8z"/></svg>
                            </a>
                            <a aria-label="facebook" class="h-8 w-8 sm:h-9 sm:w-9 rounded-full bg-white/10 hover:bg-white/20 grid place-items-center transition-colors" href="#">
                                <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" viewBox="0 0 24 24" fill="currentColor"><path d="M22 12a10 10 0 1 0-11.6 9.9v-7h-2.4V12h2.4V9.6c0-2.4 1.4-3.7 3.5-3.7 1 0 2 .17 2 .17v2.2h-1.1c-1.1 0-1.4.7-1.4 1.4V12h2.5l-.4 2.9h-2.1v7A10 10 0 0 0 22 12z"/></svg>
                            </a>
                        </div>
                    </div>
                </div>
                <!-- newsletter -->
                <div>
                    <h4 class="text-white/90 font-semibold mb-2 sm:mb-3 text-sm sm:text-base"><?php echo t('footer.newsletter'); ?></h4>
                    <p class="text-gray-400 mb-3 sm:mb-4 text-sm sm:text-base"><?php echo t('footer.newsletter_desc'); ?></p>
                    <form class="flex gap-2" onsubmit="event.preventDefault(); this.reset();">
                        <input type="email" required placeholder="<?php echo t('footer.email_placeholder'); ?>" class="w-full px-3 py-2 rounded-md bg-white/10 text-white placeholder-white/50 ring-1 ring-white/20 focus:outline-none focus:ring-primary-400 text-sm sm:text-base">
                        <button class="btn-asym px-3 py-2 sm:px-4 sm:py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold text-sm sm:text-base"><?php echo t('footer.subscribe'); ?></button>
                    </form>
                </div>
            </div>
            <div class="mt-8 md:mt-10 border-t border-white/10 pt-4 md:pt-6 flex flex-col sm:flex-row items-center gap-2 sm:gap-3 justify-between text-xs sm:text-sm text-gray-400">
                <p class="text-center">&copy; <?php echo date('Y'); ?> <?php echo t('footer.copyright'); ?></p>
                <div class="flex gap-3 sm:gap-4">
                    <a href="#" class="hover:text-white"><?php echo t('footer.privacy'); ?></a>
                    <span class="opacity-30">|</span>
                    <a href="#" class="hover:text-white"><?php echo t('footer.terms'); ?></a>
                </div>
            </div>
        </div>
    </footer>
<script>
  if (window.lucide && typeof window.lucide.createIcons === 'function') {
    window.lucide.createIcons();
  }
</script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // i18n via PHP routing (no JS needed now)

            const header = document.getElementById('site-header');
            const nav = document.getElementById('site-header-nav');
            const info = document.getElementById('header-info');
            const logoImg = header ? header.querySelector('img[src$="logo.svg"]') : null;
            const forceSolid = header && header.getAttribute('data-force-solid') === 'true';

            const setTransparent = () => {
                if (!header) return;
                header.classList.add('bg-transparent','text-white');
                header.classList.remove('bg-white','bg-white/90','text-black','shadow-md','backdrop-blur');
                if (logoImg) logoImg.style.filter = 'brightness(0) invert(1)';
                if (nav) {
                    nav.classList.add('bg-transparent');
                    nav.classList.remove('bg-white');
                }
                if (info) {
                  info.querySelectorAll('.info-title').forEach(el=> el.classList.remove('text-gray-800'));
                  info.querySelectorAll('.info-title').forEach(el=> el.classList.add('text-white/90'));
                  info.querySelectorAll('.info-sub').forEach(el=> { el.classList.remove('text-gray-500'); el.classList.add('text-white/70'); });
                  info.querySelectorAll('.info-icon').forEach(el=> el.classList.add('text-white/80'));
                }
            };
            const setSolid = () => {
                if (!header) return;
                header.classList.remove('bg-transparent','text-white');
                header.classList.add('bg-white/90','backdrop-blur','text-black','shadow-md');
                if (logoImg) logoImg.style.filter = '';
                if (nav) {
                    nav.classList.remove('bg-transparent');
                    nav.classList.add('bg-white');
                }
                if (info) {
                  info.querySelectorAll('.info-title').forEach(el=> { el.classList.remove('text-white/90'); el.classList.add('text-gray-800'); });
                //   info.querySelectorAll('.info-sub').forEach(el=> { el.classList.remove('text-white/70'); el.classList.add('text-gray-500'); });
                  info.querySelectorAll('.info-icon').forEach(el=> el.classList.remove('text-white/80'));
                }
            };

            if (!header) return;
            if (forceSolid) {
                setSolid();
                return;
            }

            const onScroll = () => {
                // If any mega menu is open, keep header solid regardless of scroll
                if (document.documentElement.classList.contains('mega-open')) { setSolid(); return; }
                // On non-home pages, always force solid
                if (forceSolid) { setSolid(); return; }
                if (window.scrollY > 50) setSolid(); else setTransparent();
            };

            // initialize and bind
            requestAnimationFrame(onScroll);
            window.addEventListener('scroll', onScroll, { passive: true });
            window.addEventListener('resize', onScroll);
        });
    </script>
    
    <!-- Scroll to Top Button -->
    <button data-scroll-to-top class="fixed bottom-8 right-8 z-50 w-12 h-12 bg-primary-600 hover:bg-primary-700 text-white rounded-full shadow-lg hover:shadow-xl transition-all duration-300 ease-out opacity-0 pointer-events-none focus:outline-none focus-visible:ring-2 focus-visible:ring-primary-300 group">
        <i data-lucide="chevron-up" class="w-6 h-6 mx-auto transition-transform group-hover:-translate-y-0.5"></i>
    </button>
    
    <!-- Simple Smooth Scrolling -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Simple smooth scrolling for anchor links
            const links = document.querySelectorAll('a[href^="#"]');
            
            links.forEach(link => {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    
                    // Skip if it's just "#" or empty
                    if (href === '#' || href.length <= 1) return;
                    
                    const target = document.querySelector(href);
                    if (!target) return;
                    
                    e.preventDefault();
                    
                    // Use scrollIntoView with smooth behavior
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start',
                        inline: 'nearest'
                    });
                });
            });
            
            // Scroll to top functionality
            const scrollToTopBtn = document.querySelector('[data-scroll-to-top]');
            if (scrollToTopBtn) {
                scrollToTopBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    window.scrollTo({
                        top: 0,
                        behavior: 'smooth'
                    });
                });
            }
            
            // Show/hide scroll-to-top button
            let scrollToTopVisible = false;
            
            function toggleScrollToTop() {
                const shouldShow = window.scrollY > 300;
                
                if (shouldShow && !scrollToTopVisible) {
                    scrollToTopVisible = true;
                    if (scrollToTopBtn) {
                        scrollToTopBtn.classList.remove('opacity-0', 'pointer-events-none');
                        scrollToTopBtn.classList.add('opacity-100');
                    }
                } else if (!shouldShow && scrollToTopVisible) {
                    scrollToTopVisible = false;
                    if (scrollToTopBtn) {
                        scrollToTopBtn.classList.add('opacity-0', 'pointer-events-none');
                        scrollToTopBtn.classList.remove('opacity-100');
                    }
                }
            }
            
            // Listen for scroll events
            window.addEventListener('scroll', toggleScrollToTop, { passive: true });
            toggleScrollToTop(); // Initial check
        });
    </script>
    
    <script src="/assets/js/hero-slider.js"></script>
</body>
</html>
