<!-- Featured Clients -->
<section class="py-10 sm:py-14 md:py-16 bg-gray-50">
        <style>
            .clients-mask { mask-image: linear-gradient(90deg, transparent, #000 10%, #000 90%, transparent); -webkit-mask-image: linear-gradient(90deg, transparent, #000 10%, #000 90%, transparent); }
            @keyframes clients-scroll {
                0% { transform: translateX(0); }
                100% { transform: translateX(-50%); }
            }
            .clients-track { animation: clients-scroll 28s linear infinite; }
        </style>
        <div class="container mx-auto px-4">
            <div class="text-center mb-8 sm:mb-9 md:mb-10">
                <h3 class="text-2xl sm:text-3xl md:text-4xl font-extrabold text-gray-900"><?php echo t('sections.clients_title'); ?></h3>
                <div class="w-16 sm:w-20 h-1 bg-primary-600 mx-auto rounded-full mt-2.5 sm:mt-3"></div>
                <p class="text-gray-600 mt-2.5 sm:mt-3 text-sm sm:text-base"><?php echo t('sections.clients_desc'); ?></p>
            </div>
            <?php 
                $clients = [
                    [ 'src' => '/assets/img/clients/saudi-aramco-logo.png', 'alt' => 'Saudi Aramco' ],
                    [ 'src' => '/assets/img/clients/National-grid-sa.webp', 'alt' => 'National Grid SA' ],
                    [ 'src' => '/assets/img/clients/National-Water-Company-Saudi-Arabia-01.webp', 'alt' => 'National Water Company' ],
                    [ 'src' => '/assets/img/clients/marafiq.png', 'alt' => 'Marafiq' ],
                    [ 'src' => '/assets/img/clients/RC-Logo-.png', 'alt' => 'Royal Commission' ],
                    [ 'src' => '/assets/img/clients/elecrtic0company.svg', 'alt' => 'Electric Company' ],
                ];
            ?>
            <div class="relative">
                <div class="overflow-hidden clients-mask">
                    <div dir="ltr" class="flex items-center gap-4 sm:gap-6 md:gap-8 clients-track will-change-transform">
                        <?php for ($r = 0; $r < 2; $r++): ?>
                            <?php foreach ($clients as $client): ?>
                                <div class="h-24 sm:h-28 md:h-32 min-w-[180px] sm:min-w-[210px] md:min-w-[250px] bg-white rounded-xl border border-gray-200 flex items-center justify-center p-3 sm:p-4">
                                    <img src="<?php echo $client['src']; ?>" alt="<?php echo htmlspecialchars($client['alt']); ?>" class="h-full object-contain"/>
                    </div>
                            <?php endforeach; ?>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>