<style>
        :root {
            --gradient-primary: linear-gradient(135deg, #342e87, #5a55c0);
            --gradient-accent: linear-gradient(135deg, #0ea5e9, #38bdf8);
            --gradient-hero: linear-gradient(135deg, #342e87, #5a55c0, #0ea5e9);
            --gradient-radial: radial-gradient(circle, rgba(52, 46, 135, 0.30) 0%, transparent 70%);
            --gradient-diagonal: linear-gradient(135deg, #f8fafc 0%, #edf2f7 50%, #f8fafc 100%);
            --gradient-overlay: linear-gradient(45deg, rgba(52, 46, 135, 0.22), rgba(14, 165, 233, 0.20));
            
            --shadow-elegant: 0 20px 40px -10px rgba(0, 0, 0, 0.15);
            --shadow-glow: 0 0 40px rgba(59, 130, 246, 0.4);
            --shadow-badge: 0 10px 30px -5px rgba(245, 158, 11, 0.3);
            --shadow-card: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
            --shadow-dramatic: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            --shadow-floating: 0 15px 35px -5px rgba(0, 0, 0, 0.2);
            
            --foreground: #1f2937;
            --muted-foreground: #6b7280;
            --card: #ffffff;
            --border: #e5e7eb;
            --primary-foreground: #ffffff;
            --accent-foreground: #ffffff;
        }

        .bg-gradient-primary { background: var(--gradient-primary); }
        .bg-gradient-accent { background: var(--gradient-accent); }
        .bg-gradient-hero { background: var(--gradient-hero); }
        .bg-gradient-radial { background: var(--gradient-radial); }
        .bg-gradient-diagonal { background: var(--gradient-diagonal); }
        .bg-gradient-overlay { background: var(--gradient-overlay); }
        
        .shadow-elegant { box-shadow: var(--shadow-elegant); }
        .shadow-glow { box-shadow: var(--shadow-glow); }
        .shadow-badge { box-shadow: var(--shadow-badge); }
        .shadow-card { box-shadow: var(--shadow-card); }
        .shadow-dramatic { box-shadow: var(--shadow-dramatic); }
        .shadow-floating { box-shadow: var(--shadow-floating); }
        
        .text-foreground { color: var(--foreground); }
        .text-muted-foreground { color: var(--muted-foreground); }
        .bg-card { background-color: var(--card); }
        .border-border { border-color: var(--border); }
        .text-primary-foreground { color: var(--primary-foreground); }
        .text-accent-foreground { color: var(--accent-foreground); }

        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        @keyframes fade-in-up {
            0% { transform: translateY(60px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        
        @keyframes slide-up {
            0% { transform: translateY(30px); opacity: 0; }
            100% { transform: translateY(0); opacity: 1; }
        }
        
        @keyframes glow-pulse {
            0%, 100% { box-shadow: 0 0 40px rgba(59, 130, 246, 0.4); }
            50% { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25); }
        }
        /* moving dot under heading */
        @keyframes dot-horizontal {
            0% { transform: translateX(0); }
            100% { transform: translateX(calc(100% - 0.75rem)); }
        }
        .animate-dot-horizontal { animation: dot-horizontal 2s ease-in-out infinite alternate; }
        
        .animate-float { animation: float 6s ease-in-out infinite; }
        .animate-fade-in-up { animation: fade-in-up 1s ease-out; }
        .animate-slide-up { animation: slide-up 0.8s ease-out; }
        .animate-glow-pulse { animation: glow-pulse 4s ease-in-out infinite; }
        
        .transition-smooth { transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .transition-bounce { transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55); }
    </style>
    <!-- About Us Section - Exact Copy -->
    <section class="relative py-14 sm:py-20 md:py-28 px-4 bg-gray-50 overflow-hidden">
        <!--  Background Elements -->
        <div class="absolute inset-0">
            <div class="absolute top-20 left-1/4 w-96 h-96 bg-gradient-radial animate-float"></div>
            <div class="absolute bottom-20 right-1/4 w-80 h-80 bg-gradient-radial animate-float" style="animation-delay: 2s;"></div>
            <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-gradient-radial opacity-50"></div>
            <div class="pointer-events-none">
                <div class="absolute -top-12 -left-12 w-64 h-64 rounded-full blur-2xl opacity-20" style="background-color: rgb(52 46 135 / 0.35);"></div>
                <div class="absolute -top-10 -right-8 w-56 h-56 rounded-full blur-xl opacity-15" style="background-color: rgb(14 165 233 / 0.28);"></div>
                <div class="absolute top-1/3 -left-6 w-48 h-48 rounded-full blur-xl opacity-12" style="background-color: rgb(14 165 233 / 0.22);"></div>
                <div class="absolute top-1/2 -right-6 w-56 h-56 rounded-full blur-xl opacity-12" style="background-color: rgb(52 46 135 / 0.25);"></div>
                <div class="absolute -bottom-12 -left-10 w-72 h-72 rounded-full blur-2xl opacity-18" style="background-color: rgb(14 165 233 / 0.24);"></div>
                <div class="absolute -bottom-14 -right-12 w-80 h-80 rounded-full blur-2xl opacity-18" style="background-color: rgb(52 46 135 / 0.22);"></div>
                </div>
            </div>

        <div class="relative container  mx-auto">
            <div class="grid lg:grid-cols-2 gap-6 sm:gap-10 md:gap-14 xl:gap-16 items-center">
                <div class="space-y-8 animate-slide-up rtl:text-right ltr:text-left">
                    <div class="relative">
                        <h2 class="text-2xl sm:text-3xl md:text-5xl font-extrabold tracking-tight text-primary-700 mb-3 sm:mb-4"><?php echo t('about2.title'); ?></h2>
                        <span class="pointer-events-none absolute -z-10 left-1/2 -translate-x-1/2 -top-2 h-16 w-48 rounded-full blur-2xl opacity-25" style="background-color: rgb(52 46 135 / 0.35);"></span>
                        <div class="relative w-16 sm:w-20 h-1 bg-primary-600 rounded-full rtl:ml-auto ltr:mr-auto">
                            <span class="absolute -top-1 left-0 h-3 w-3 bg-primary-600 rounded-full animate-dot-horizontal"></span>
                        </div>
            </div>
                    <div>
                        <p class="text-base sm:text-lg text-gray-800 leading-relaxed max-w-3xl mx-auto lg:mx-0 mb-3 sm:mb-4 rtl:text-right ltr:text-left"><?php echo t('about2.intro1'); ?></p>
                        <p class="text-base sm:text-lg text-gray-800 leading-relaxed max-w-3xl mx-auto lg:mx-0 rtl:text-right ltr:text-left"><?php echo t('about2.intro2'); ?></p>
                    </div>

                    <!--  Features Grid -->
                    <div class="grid gap-4 sm:gap-5 md:gap-6">
                        <div class="flex items-start gap-3 sm:gap-4 group rtl:flex-row ltr:flex-row">
                            <div class="bg-gradient-accent p-2.5 sm:p-3 rounded-2xl shadow-badge ring-1 ring-white/20 group-hover:shadow-floating transition-all duration-300">
                                <svg class="w-5 h-5 sm:w-6 sm:h-6 text-accent-foreground" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="text-base sm:text-lg font-semibold text-foreground mb-0.5 sm:mb-1"><?php echo t('about2.features.f1.title'); ?></p>
                                <p class="text-sm sm:text-base text-muted-foreground"><?php echo t('about2.features.f1.desc'); ?></p>
                            </div>
                        </div>
                        
                        <div class="flex items-start gap-3 sm:gap-4 group rtl:flex-row ltr:flex-row">
                            <div class="bg-gradient-primary p-2.5 sm:p-3 rounded-2xl shadow-glow ring-1 ring-white/20 group-hover:shadow-dramatic transition-all duration-300">
                                <svg class="w-5 h-5 sm:w-6 sm:h-6 text-primary-foreground" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="text-base sm:text-lg font-semibold text-foreground mb-0.5 sm:mb-1"><?php echo t('about2.features.f2.title'); ?></p>
                                <p class="text-sm sm:text-base text-muted-foreground"><?php echo t('about2.features.f2.desc'); ?></p>
                            </div>
                        </div>
                        
                        <div class="flex items-start gap-3 sm:gap-4 group rtl:flex-row ltr:flex-row">
                            <div class="bg-gradient-accent p-2.5 sm:p-3 rounded-2xl shadow-badge ring-1 ring-white/20 group-hover:shadow-floating transition-all duration-300">
                                <svg class="w-5 h-5 sm:w-6 sm:h-6 text-accent-foreground" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <p class="text-base sm:text-lg font-semibold text-foreground mb-0.5 sm:mb-1"><?php echo t('about2.features.f3.title'); ?></p>
                                <p class="text-sm sm:text-base text-muted-foreground"><?php echo t('about2.features.f3.desc'); ?></p>
                            </div>
                        </div>
                    </div>

                    <!--  Buttons -->
                    <div class="flex flex-col sm:flex-row gap-3 sm:gap-4 pt-5 sm:pt-6 rtl:flex-row ltr:flex-row">
                        <button class="btn-asym bg-gradient-primary text-primary-foreground hover:shadow-glow transition-all duration-300 text-sm sm:text-base md:text-lg px-5 py-2.5 sm:px-7 sm:py-3 md:px-8 md:py-4 font-medium shadow-glow inline-flex items-center justify-center gap-2 whitespace-nowrap focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-offset-2"><?php echo t('about2.cta_learn'); ?></button>
                        <button class="btn-asym border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white transition-all duration-300 text-sm sm:text-base md:text-lg px-5 py-2.5 sm:px-7 sm:py-3 md:px-8 md:py-4 font-medium hover:shadow-elegant inline-flex items-center justify-center gap-2 whitespace-nowrap focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-offset-2"><?php echo t('about2.cta_contact'); ?></button>
                    </div>
                </div>

                <!--  Images Column -->
                <div class="relative h-[440px] sm:h-[540px] md:h-[660px] animate-slide-up m-5" style="animation-delay: 0.3s;height: 440px;">
                    <div class="absolute top-0 rtl:right-0 ltr:left-0 w-4/5 group">
                        <div class="relative overflow-hidden rounded-2xl md:rounded-[2rem] shadow-dramatic group-hover:shadow-floating transition-all duration-300 ring-1 ring-gray-200/70 group-hover:ring-primary-200/60 transform group-hover:-translate-y-0.5">
                            <img 
                                src="/assets/img/about/img-1.png" 
                                alt="image 1" 
                                class="w-full h-56 sm:h-72 md:h-[22rem] object-cover transform group-hover:scale-110 transition-all duration-700"
                            />
                            <div class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-blue-600/10"></div>
                            <div class="absolute inset-0 bg-gradient-overlay opacity-0 group-hover:opacity-20 transition-all duration-300"></div>
                        </div>
                        
                        <!--  Experience Badge -->
						<div class="absolute -top-6 sm:-top-8 rtl:-right-6 sm:rtl:-right-8 ltr:-left-6 sm:ltr:-left-8 bg-gradient-accent text-white rounded-2xl sm:rounded-3xl w-20 h-20 sm:w-24 sm:h-24 md:w-28 md:h-28 p-1 sm:p-2 md:p-3 flex flex-col items-center justify-center shadow-floating ring-1 ring-white/30 transform hover:scale-110 transition-all duration-300 z-20 animate-float">
                            <!-- Calendar Icon -->
							<svg class="w-4 h-4 sm:w-6 sm:h-6 mb-1 sm:mb-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
							<span class="text-[9px] tracking-wide uppercase text-white/85"><?php echo t('about2.exp_label'); ?></span>
							<span class="text-sm sm:text-base md:text-lg font-extrabold text-white leading-none">40+</span>
							<span class="text-[8px] sm:text-[10px] font-medium text-white/95 mt-0.5"><?php echo t('about2.years_exp'); ?></span>
                            <div class="absolute inset-0 rounded-3xl bg-gradient-accent opacity-10 blur-lg"></div>
                        </div>
                    </div>

                    <div class="absolute bottom-0 rtl:left-0 ltr:right-0 w-4/5 group">
                        <div class="relative overflow-hidden rounded-2xl md:rounded-[2rem] shadow-elegant group-hover:shadow-dramatic transition-all duration-300 ring-1 ring-gray-200/70 group-hover:ring-primary-200/60 transform group-hover:-translate-y-0.5">
                            <img 
                                src="/assets/img/about/img-2.png" 
                                alt="image 2" 
                                class="w-full h-56 sm:h-72 md:h-[22rem] object-cover transform group-hover:scale-110 transition-all duration-700"
                            />
                            <div class="absolute inset-0 bg-gradient-to-t from-black/30 via-transparent to-yellow-500/10"></div>
                            <div class="absolute inset-0 bg-gradient-overlay opacity-0 group-hover:opacity-20 transition-all duration-300"></div>
                        </div>
                        
                        <!--  Projects Badge -->
						<div class="absolute -top-6 sm:-top-8 rtl:-left-6 sm:rtl:-left-8 ltr:-right-6 sm:ltr:-right-8 bg-gradient-primary text-white rounded-2xl sm:rounded-3xl w-20 h-20 sm:w-24 sm:h-24 md:w-28 md:h-28 p-1 sm:p-2 md:p-3 flex flex-col items-center justify-center shadow-glow ring-1 ring-white/30 transform hover:scale-110 transition-all duration-300 z-20 animate-float" style="animation-delay: 1s;">
                            <!-- Award Icon -->
							<svg class="w-4 h-4 sm:w-6 sm:h-6 mb-1 sm:mb-2 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
							<span class="text-[9px] tracking-wide uppercase text-white/85"><?php echo t('about2.proj_label'); ?></span>
							<span class="text-sm sm:text-lg md:text-xl font-extrabold text-white leading-none">80+</span>
							<span class="text-[8px] sm:text-[11px] font-medium text-white/95 mt-0.5"><?php echo t('about2.projects'); ?></span>
                            <div class="absolute inset-0 rounded-3xl bg-gradient-primary opacity-10 blur-lg"></div>
                        </div>
                    </div>

                    <!--  Decorative Elements -->
                    <div class="absolute top-1/4 rtl:right-1/4 ltr:left-1/4 w-3 h-3 sm:w-4 sm:h-4 md:w-5 md:h-5 bg-yellow-500/80 rounded-full animate-float shadow-badge" style="animation-delay: 0.5s;"></div>
                    <div class="absolute bottom-1/4 rtl:left-1/4 ltr:right-1/4 w-2.5 h-2.5 sm:w-3 sm:h-3 md:w-4 md:h-4 bg-blue-600/80 rounded-full animate-float shadow-glow" style="animation-delay: 1.5s;"></div>
                    <div class="absolute top-1/2 rtl:right-1/3 ltr:left-1/3 w-4 h-4 sm:w-6 sm:h-6 md:w-7 md:h-7 bg-gradient-accent rounded-full animate-float opacity-50" style="animation-delay: 2.5s;"></div>
                </div>
            </div>

            
        </div>
    </section>