<?php
require_once __DIR__ . '/inc/utils.php';

// Allow email handler access for CSRF token generation
define('EMAIL_HANDLER_ALLOWED', true);
require_once __DIR__ . '/inc/email.php';

$pageTitle = t('nav.contact') . ' - ' . t('footer.brand_name');
$pageDescription = t('contact_page.subtitle');
$activePage = 'contact';

// Language detection logic
$i18n = detect_lang();
$lang = $i18n['lang'];
$translations = load_translations();

// Generate CSRF token
$csrfToken = generateCSRFToken();

// Get correct AJAX URLs
$processContactUrl = get_ajax_url('process-contact.php');

include __DIR__ . '/inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        
        <div class="absolute top-0 left-0 w-24 h-24 bg-gradient-to-br from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-bl from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute bottom-0 left-0 w-24 h-24 bg-gradient-to-tr from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute bottom-0 right-0 w-24 h-24 bg-gradient-to-tl from-black/15 to-transparent rounded-full blur-2xl"></div>
        
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/3 rounded-full blur-2xl"></div>
        
        <div class="container mx-auto px-4 text-center relative z-10">
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 sm:mb-4 md:mb-6 drop-shadow-md"><?php echo t('nav.contact'); ?></h2>
            <p class="text-base sm:text-lg md:text-xl max-w-2xl mx-auto opacity-90 drop-shadow-sm"><?php echo t('contact_page.subtitle'); ?></p>
        </div>
    </section>

    <!-- Inquiries & Contact Info -->
    <section class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid lg:grid-cols-2 gap-8 lg:gap-12 rtl:text-right ltr:text-left">
                <div>
                    <h3 class="text-2xl md:text-3xl font-bold text-gray-800 mb-4 md:mb-6 rtl:text-right ltr:text-left"><?php echo t('contact_page.inquiries_title'); ?></h3>
                    <p class="text-base md:text-lg text-gray-600 mb-6 md:mb-8 rtl:text-right ltr:text-left"><?php echo t('contact_page.inquiries_desc'); ?></p>
                    
                        <!-- Head Office Address -->
                    <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl p-6 md:p-8 border border-gray-100 shadow-sm mb-6 md:mb-8">
                        <h4 class="text-xl md:text-2xl font-bold text-gray-800 mb-4 md:mb-6 rtl:text-right ltr:text-left"><?php echo t('contact_page.head_office_title'); ?></h4>
                        
                        <div class="space-y-6 rtl:text-right ltr:text-left">
                            <div class="flex items-start gap-3 md:gap-4 rtl:flex-row-reverse">
                                <div class="w-10 h-10 md:w-12 md:h-12 bg-primary-100 rounded-xl flex items-center justify-center shrink-0">
                                    <i data-lucide="phone" class="w-6 h-6 text-primary-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600 rtl:text-right ltr:text-left"><?php echo t('contact_page.phone_label'); ?></p>
                                    <p class="text-lg md:text-xl font-semibold text-gray-800 rtl:text-right ltr:text-left">011 2766655</p>
                                </div>
                            </div>
                            
                            
                            <div class="flex items-start gap-3 md:gap-4 rtl:flex-row-reverse">
                                <div class="w-10 h-10 md:w-12 md:h-12 bg-primary-100 rounded-xl flex items-center justify-center shrink-0">
                                    <i data-lucide="map-pin" class="w-6 h-6 text-primary-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600 rtl:text-right ltr:text-left"><?php echo t('contact_page.address_label'); ?></p>
                                    <p class="text-base md:text-lg font-semibold text-gray-800 rtl:text-right ltr:text-left"><?php echo t('footer.address'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Employment Section -->
                    <div class="bg-white rounded-2xl p-6 md:p-8 border border-gray-100 shadow-sm">
                        <h4 class="text-xl md:text-2xl font-bold text-gray-800 mb-3 md:mb-4 rtl:text-right ltr:text-left"><?php echo t('contact_page.employment_title'); ?></h4>
                        <p class="text-base md:text-lg text-gray-600 mb-5 md:mb-6 rtl:text-right ltr:text-left"><?php echo t('contact_page.employment_desc'); ?></p>
                        
                        <div class="text-center">
                            <a href="<?php echo $i18n['prefix']; ?>/career.php" 
                                class="inline-flex items-center gap-2 md:gap-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold py-2.5 md:py-3 px-5 md:px-6 rounded-lg transition duration-300 ease-in-out transform hover:scale-105">
                                <?php echo t('contact_page.view_jobs'); ?>
                                <i data-lucide="arrow-right" class="w-4 h-4"></i>
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Contact Form -->
                <div>
                    <h3 class="text-2xl md:text-3xl font-bold text-gray-800 mb-4 md:mb-6 rtl:text-right ltr:text-left"><?php echo t('contact_page.form_title'); ?></h3>
                    <form class="space-y-5 md:space-y-6" id="contactForm">
                        <!-- CSRF Protection -->
                        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfToken); ?>">
                        
                        <div class="grid md:grid-cols-2 gap-4 md:gap-6">
                            <div>
                                <label for="firstName" class="block text-sm font-medium text-gray-700 mb-1.5 md:mb-2 rtl:text-right ltr:text-left"><?php echo t('contact_page.first_name'); ?></label>
                                <input type="text" id="firstName" name="firstName" required
                                    class="w-full px-4 py-2.5 md:py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition duration-300">
                            </div>
                            <div>
                                <label for="lastName" class="block text-sm font-medium text-gray-700 mb-1.5 md:mb-2 rtl:text-right ltr:text-left"><?php echo t('contact_page.last_name'); ?></label>
                                <input type="text" id="lastName" name="lastName" required
                                    class="w-full px-4 py-2.5 md:py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition duration-300">
                            </div>
                        </div>
                        
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1.5 md:mb-2 rtl:text-right ltr:text-left"><?php echo t('contact_page.email'); ?></label>
                            <input type="email" id="email" name="email" required
                                class="w-full px-4 py-2.5 md:py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition duration-300">
                        </div>
                        
                        <div>
                            <label for="subject" class="block text-sm font-medium text-gray-700 mb-1.5 md:mb-2 rtl:text-right ltr:text-left"><?php echo t('contact_page.subject'); ?></label>
                            <input type="text" id="subject" name="subject" required
                                class="w-full px-4 py-2.5 md:py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition duration-300">
                        </div>
                        
                        <div>
                            <label for="message" class="block text-sm font-medium text-gray-700 mb-1.5 md:mb-2 rtl:text-right ltr:text-left"><?php echo t('contact_page.message'); ?></label>
                            <textarea id="message" name="message" rows="5" required
                                placeholder="<?php echo t('contact_page.message_placeholder'); ?>"
                                class="w-full px-4 py-2.5 md:py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary-500 focus:border-transparent transition duration-300"></textarea>
                        </div>
                        
                        <button type="submit" 
                            class="w-full bg-primary-600 hover:bg-primary-700 text-white font-semibold py-3 md:py-4 px-6 rounded-lg transition duration-300 ease-in-out transform hover:scale-105">
                            <?php echo t('contact_page.submit'); ?>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>


    <script>
        // Get translations for JavaScript
        const translations = {
            requiredFields: '<?php echo addslashes(t('contact_page.form_validation.required_fields')); ?>',
            invalidEmail: '<?php echo addslashes(t('contact_page.form_validation.invalid_email')); ?>',
            sending: '<?php echo addslashes(t('contact_page.form_validation.sending')); ?>',
            networkError: '<?php echo addslashes(t('contact_page.form_validation.network_error')); ?>'
        };
        
        document.getElementById('contactForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.textContent;
            
            // Client-side validation
            const formData = new FormData(this);
            const firstName = formData.get('firstName')?.trim();
            const lastName = formData.get('lastName')?.trim();
            const email = formData.get('email')?.trim();
            const subject = formData.get('subject')?.trim();
            const message = formData.get('message')?.trim();
            
            // Basic validation
            if (!firstName || !lastName || !email || !subject || !message) {
                alert(translations.requiredFields);
                return;
            }
            
            // Email validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(email)) {
                alert(translations.invalidEmail);
                return;
            }
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.textContent = translations.sending;
            submitBtn.classList.add('opacity-75');
            
            try {
                const processUrl = '<?php echo htmlspecialchars($processContactUrl, ENT_QUOTES, 'UTF-8'); ?>';
                
                const response = await fetch(processUrl, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                });
                
                const result = await response.json();
                
                if (result.success) {
                    // Success message
                    alert(result.message);
                    this.reset();
                    
                    // Generate new CSRF token
                    const csrfResponse = await fetch(processUrl + '?action=csrf');
                    const csrfData = await csrfResponse.json();
                    if (csrfData.token) {
                        this.querySelector('input[name="csrf_token"]').value = csrfData.token;
                    }
                } else {
                    alert(result.message);
                }
            } catch (error) {
                console.error('Network error:', error);
                alert(translations.networkError);
            } finally {
                // Reset button state
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
                submitBtn.classList.remove('opacity-75');
            }
        });
        
        // Add input validation feedback
        document.querySelectorAll('#contactForm input, #contactForm textarea').forEach(input => {
            input.addEventListener('blur', function() {
                if (this.hasAttribute('required') && !this.value.trim()) {
                    this.classList.add('border-red-300');
                    this.classList.remove('border-gray-300');
                } else {
                    this.classList.remove('border-red-300');
                    this.classList.add('border-gray-300');
                }
            });
        });
    </script>

<!-- Google Map Section -->
<section class="py-12 md:py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-6 md:mb-8">
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 md:mb-4"><?php echo t('contact_page.map_title'); ?></h2>
            <p class="text-base md:text-xl text-gray-600"><?php echo t('contact_page.map_address'); ?></p>
        </div>
        
        <!-- Google Map -->
        <div class="rounded-2xl overflow-hidden shadow-lg">
            <iframe 
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3625.8116386474703!2d46.700531!3d24.664611100000002!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2f048e399979af%3A0x99457cfc20551d8e!2z2LTYsdmD2Kkg2KfZhNi32YjYrtmKINmE2YTYtdmG2KfYudipINmI2KfZhNiq2KzYp9ix2Kkg2YjYp9mE2YXZgtin2YjZhNin2Ko!5e0!3m2!1sar!2seg!4v1759081850240!5m2!1sar!2seg&t=h" 
                width="100%" 
                height="450" 
                style="border:0;" 
                allowfullscreen="" 
                loading="lazy" 
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>
        
    </div>
</section>

<?php include __DIR__ . '/inc/footer.php'; ?>

