<?php
require_once __DIR__ . '/inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('clients_page.header_title', 'Our Valued Clients');
$pageDescription = t('clients_page.header_desc', 'Trusted by Leading Organizations');
$activePage = 'clients';
include __DIR__ . '/inc/header.php';

// تعريف بيانات العملاء
$clients = [
    [
        'src' => '/assets/img/clients/saudi-aramco-logo.png',
        'alt' => 'Saudi Aramco',
        'name' => 'Saudi Aramco',
        'name_ar' => 'أرامكو السعودية',
        'description' => 'Leading global integrated energy and chemicals company',
        'description_ar' => 'شركة عالمية رائدة متكاملة في مجال الطاقة والكيماويات',
        'sector' => 'Energy',
        'sector_ar' => 'الطاقة',
        'projects' => '25+',
        'years' => '10+'
    ],
    [
        'src' => '/assets/img/clients/National-grid-sa.webp',
        'alt' => 'National Grid SA',
        'name' => 'National Grid SA',
        'name_ar' => 'الشركة الوطنية لنقل الكهرباء',
        'description' => 'Saudi Arabia\'s national electricity transmission network',
        'description_ar' => 'شبكة نقل الكهرباء الوطنية في المملكة العربية السعودية',
        'sector' => 'Electricity',
        'sector_ar' => 'الكهرباء',
        'projects' => '18+',
        'years' => '8+'
    ],
    [
        'src' => '/assets/img/clients/National-Water-Company-Saudi-Arabia-01.webp',
        'alt' => 'National Water Company',
        'name' => 'National Water Company',
        'name_ar' => 'شركة المياه الوطنية',
        'description' => 'Saudi Arabia\'s water and wastewater services provider',
        'description_ar' => 'مزود خدمات المياه والصرف الصحي في المملكة',
        'sector' => 'Water & Utilities',
        'sector_ar' => 'المياه والمرافق',
        'projects' => '30+',
        'years' => '12+'
    ],
    [
        'src' => '/assets/img/clients/marafiq.png',
        'alt' => 'Marafiq',
        'name' => 'Marafiq',
        'name_ar' => 'مرافق',
        'description' => 'Leading utilities services provider in Saudi Arabia',
        'description_ar' => 'مزود رائد لخدمات المرافق في المملكة العربية السعودية',
        'sector' => 'Utilities',
        'sector_ar' => 'المرافق',
        'projects' => '22+',
        'years' => '9+'
    ],
    [
        'src' => '/assets/img/clients/RC-Logo-.png',
        'alt' => 'Royal Commission',
        'name' => 'Royal Commission',
        'name_ar' => 'الهيئة الملكية',
        'description' => 'Royal Commission for Jubail and Yanbu',
        'description_ar' => 'الهيئة الملكية للجبيل وينبع',
        'sector' => 'Government',
        'sector_ar' => 'حكومي',
        'projects' => '15+',
        'years' => '7+'
    ],
    [
        'src' => '/assets/img/clients/elecrtic0company.svg',
        'alt' => 'Electric Company',
        'name' => 'Saudi Electricity Company',
        'name_ar' => 'الشركة السعودية للكهرباء',
        'description' => 'Kingdom\'s primary electricity service provider',
        'description_ar' => 'مزود الخدمات الكهربائية الرئيسي في المملكة',
        'sector' => 'Electricity',
        'sector_ar' => 'الكهرباء',
        'projects' => '28+',
        'years' => '11+'
    ]
];
?>

<!-- Page Header -->
<section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
    <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
    <div class="absolute top-0 left-0 w-24 h-24 bg-gradient-to-br from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-bl from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute bottom-0 left-0 w-24 h-24 bg-gradient-to-tr from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute bottom-0 right-0 w-24 h-24 bg-gradient-to-tl from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/3 rounded-full blur-2xl"></div>

    <div class="container mx-auto px-4 text-center relative z-10">
        <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 sm:mb-4 md:mb-6 drop-shadow-md">
            <?php echo t('clients_page.header_title', 'Our Valued Clients'); ?>
        </h2>
        <p class="text-base sm:text-lg md:text-xl max-w-2xl mx-auto opacity-90 drop-shadow-sm">
            <?php echo t('clients_page.header_desc', 'Trusted partnerships with leading organizations across Saudi Arabia'); ?>
        </p>
    </div>
</section>

<!-- Main Clients Display -->
<section class="py-12 sm:py-16 bg-gradient-to-b from-gray-50 to-white">
    <div class="container mx-auto px-4 sm:px-6">
        <div class="max-w-7xl mx-auto">

            <!-- Section Title -->
            <div class="text-center mb-10 sm:mb-14">
                <div class="inline-flex items-center gap-2 px-3 sm:px-4 py-1.5 sm:py-2 bg-primary-100 text-primary-600 rounded-full text-xs sm:text-sm font-semibold mb-4 sm:mb-6">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                    <span><?php echo t('clients_page.section_badge', 'Strategic Partners'); ?></span>
                </div>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-3 sm:mb-4">
                    <?php echo t('clients_page.section_title', 'Industry Leaders Trust Us'); ?>
                </h2>
                <p class="text-base sm:text-lg text-gray-600 max-w-2xl mx-auto">
                    <?php echo t('clients_page.section_desc', 'We are proud to serve prestigious organizations and contribute to their success'); ?>
                </p>
            </div>

            <!-- Clients Grid - Modern Card Design -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 sm:gap-8">
                <?php foreach ($clients as $index => $client): ?>
                    <?php 
                        $clientName = ($i18n['lang'] === 'ar') ? $client['name_ar'] : $client['name'];
                        $clientDesc = ($i18n['lang'] === 'ar') ? $client['description_ar'] : $client['description'];
                        $clientSector = ($i18n['lang'] === 'ar') ? $client['sector_ar'] : $client['sector'];
                    ?>
                    
                    <div class="group relative bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden border border-gray-100 hover:border-primary-600">
                        
                        <!-- Gradient Overlay on Hover -->
                        <div class="absolute inset-0 bg-gradient-to-br from-primary-600/0 to-primary-600/0 group-hover:from-primary-600/5 group-hover:to-primary-600/10 transition-all duration-500 pointer-events-none"></div>
                        
                        <!-- Card Content -->
                        <div class="relative p-6 sm:p-8">
                            
                            <!-- Logo Container -->
                            <div class="bg-gray-50 rounded-xl p-5 sm:p-6 mb-5 sm:mb-6 h-36 sm:h-40 flex items-center justify-center group-hover:bg-white transition-colors duration-300 border border-gray-100">
                                <img 
                                    src="<?php echo $client['src']; ?>" 
                                    alt="<?php echo $client['alt']; ?>" 
                                    class="w-full h-full object-contain transform group-hover:scale-110 transition-transform duration-500"
                                />
                            </div>

                            <!-- Sector Badge -->
                            <div class="inline-flex items-center gap-1.5 px-2.5 sm:px-3 py-1.5 bg-primary-100 text-primary-600 rounded-lg text-[11px] sm:text-xs font-bold mb-3 sm:mb-4">
                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                                </svg>
                                <span><?php echo $clientSector; ?></span>
                            </div>

                            <!-- Client Name -->
                            <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-2.5 sm:mb-3 group-hover:text-primary-600 transition-colors duration-300">
                                <?php echo $clientName; ?>
                            </h3>

                            <!-- Description -->
                            <p class="text-gray-600 text-[13px] sm:text-sm leading-relaxed mb-5 sm:mb-6 line-clamp-2">
                                <?php echo $clientDesc; ?>
                            </p>

                            <!-- Stats -->
                            <div class="flex items-center justify-between pt-3 sm:pt-4 border-t border-gray-100">
                                <div class="flex items-center gap-2 text-sm">
                                    <svg class="w-4 h-4 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                    </svg>
                                    <span class="font-semibold text-gray-700"><?php echo $client['projects']; ?></span>
                                    <span class="text-gray-500 text-xs"><?php echo t('clients_page.projects', 'Projects'); ?></span>
                                </div>
                                <div class="flex items-center gap-2 text-sm">
                                    <svg class="w-4 h-4 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    <span class="font-semibold text-gray-700"><?php echo $client['years']; ?></span>
                                    <span class="text-gray-500 text-xs"><?php echo t('clients_page.years', 'Years'); ?></span>
                                </div>
                            </div>

                            <!-- Hover Indicator -->
                            <div class="absolute bottom-0 left-0 w-full h-1 bg-gradient-to-r from-primary-600 to-primary-700 transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500 origin-left"></div>
                        
                        </div>
                    </div>

                <?php endforeach; ?>
            </div>

        </div>
    </div>
</section>

<?php include __DIR__ . '/inc/footer.php'; ?>




