<?php
require_once __DIR__ . '/inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('certificates_page.header_title', 'Certificates & Accreditations');
$pageDescription = t('certificates_page.header_desc', 'Our Certifications and Quality Standards');
$activePage = 'certificates';
include __DIR__ . '/inc/header.php';
?>

<!-- Page Header (styled like career.php) -->
<section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
    <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
    <div class="absolute top-0 left-0 w-24 h-24 bg-gradient-to-br from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-bl from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute bottom-0 left-0 w-24 h-24 bg-gradient-to-tr from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute bottom-0 right-0 w-24 h-24 bg-gradient-to-tl from-black/15 to-transparent rounded-full blur-2xl"></div>
    <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/3 rounded-full blur-2xl"></div>

    <div class="container mx-auto px-4 text-center relative z-10">
        <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 sm:mb-4 md:mb-6 drop-shadow-md"><?php echo t('certificates_page.header_title', 'Certificates & Accreditations'); ?></h2>
        <p class="text-base sm:text-lg md:text-xl max-w-2xl mx-auto opacity-90 drop-shadow-sm"><?php echo t('certificates_page.header_desc', 'Recognized excellence and certified quality standards'); ?></p>
    </div>
</section>


<!-- Main Certificates Display -->
<section class="py-12 sm:py-16 bg-white">
    <div class="container mx-auto px-4 sm:px-6">
        <div class="max-w-7xl mx-auto">

            <!-- Section Title -->
            <div class="text-center mb-10 sm:mb-14 lg:mb-16">
                <div class="inline-flex items-center gap-2 px-3 sm:px-4 py-1.5 sm:py-2 bg-primary-100 text-primary-600 rounded-full text-xs sm:text-sm font-semibold mb-4 sm:mb-6">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    <span><?php echo t('certificates_page.section_badge', 'Official Certifications'); ?></span>
                </div>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-3 sm:mb-4">
                    <?php echo t('certificates_page.section_title', 'Our Accreditations'); ?>
                </h2>
                <p class="text-base sm:text-lg text-gray-600 max-w-2xl mx-auto">
                    <?php echo t('certificates_page.section_desc', 'Officially recognized certifications validating our expertise and commitment to quality'); ?>
                </p>
            </div>

            <!-- Certificate 1 - Full Width Feature -->
            <div class="mb-8 sm:mb-12">
                <div class="bg-gradient-to-br from-primary-100 to-primary-100 rounded-2xl sm:rounded-3xl shadow-xl overflow-hidden border border-primary-100">
                    <div class="grid lg:grid-cols-2 gap-0">
                        
                        <!-- Image Side -->
                        <div class="relative bg-white p-6 sm:p-8 lg:p-12 flex items-center justify-center order-2 lg:order-1">
                            <div class="relative max-w-md w-full mx-auto">
                                <!-- Decorative Background -->
                                <div class="absolute inset-0 bg-primary-600 opacity-5 rounded-2xl transform rotate-3"></div>
                                <div class="absolute inset-0 bg-primary-600 opacity-5 rounded-2xl transform -rotate-3"></div>
                                
                                <!-- Certificate Image -->
                                <div class="relative bg-white rounded-2xl shadow-2xl overflow-hidden border border-gray-200 transform hover:scale-105 transition-transform duration-500">
                                    <img 
                                        src="https://smartive.com.sa/assets/imgs/certificate/cert-1.png" 
                                        alt="Grade-1 Contractor Certificate" 
                                        class="w-full h-auto object-contain"
                                    />
                                </div>

                                <!-- Floating Badge -->
                                <div class="absolute -top-3 -right-3 sm:-top-4 sm:-right-4 bg-primary-600 text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-xl shadow-xl z-10">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        <span class="font-bold"><?php echo t('certificates_page.cert1_badge', 'Official'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Content Side -->
                        <div class="p-6 sm:p-8 lg:p-12 flex flex-col justify-center order-1 lg:order-2">
                            <div class="inline-flex items-center gap-2 bg-primary-600 text-white px-3 sm:px-4 py-1.5 sm:py-2 rounded-lg text-xs sm:text-sm font-bold mb-4 sm:mb-6 self-start">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                </svg>
                                <span><?php echo t('certificates_page.cert1_type', 'Government Certification'); ?></span>
                            </div>

                            <h3 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-3 sm:mb-4">
                                <?php echo t('certificates_page.cert1_title', 'Grade-1 Contractor License'); ?>
                            </h3>

                            <p class="text-base sm:text-lg text-gray-700 leading-relaxed mb-4 sm:mb-6">
                                <?php echo t('certificates_page.cert1_desc', 'Grade-1 contractor in electro-mechanical contracting by the Ministry of Public Works & Housing, Saudi Arabia'); ?>
                            </p>

                            <!-- Features List -->
                            <div class="space-y-3 sm:space-y-4">
                                <div class="flex items-start gap-3">
                                <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert1_feature1', 'Highest Classification'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert1_feature1_desc', 'Top-tier contractor status for large-scale projects'); ?></p>
                                    </div>
                                </div>

                                <div class="flex items-start gap-3">
                                <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert1_feature2', 'Government Approved'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert1_feature2_desc', 'Officially recognized by Saudi authorities'); ?></p>
                                    </div>
                                </div>

                                <div class="flex items-start gap-3">
                                <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert1_feature3', 'Electro-Mechanical Expertise'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert1_feature3_desc', 'Specialized in complex technical projects'); ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-6 sm:mt-8 flex items-center gap-2 text-primary-600 font-bold">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <span><?php echo t('certificates_page.cert1_status', 'Active & Valid Certification'); ?></span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Certificate 2 - Full Width Feature (Reversed) -->
            <div class="mb-8 sm:mb-12">
                <div class="bg-gradient-to-br from-primary-100 to-primary-100 rounded-2xl sm:rounded-3xl shadow-xl overflow-hidden border border-primary-100">
                    <div class="grid lg:grid-cols-2 gap-0">
                        
                        <!-- Content Side -->
                        <div class="p-6 sm:p-8 lg:p-12 flex flex-col justify-center">
                            <div class="inline-flex items-center gap-2 bg-primary-600 text-white px-3 sm:px-4 py-1.5 sm:py-2 rounded-lg text-xs sm:text-sm font-bold mb-4 sm:mb-6 self-start">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"/>
                                </svg>
                                <span><?php echo t('certificates_page.cert2_type', 'International Standard'); ?></span>
                            </div>

                            <h3 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-3 sm:mb-4">
                                <?php echo t('certificates_page.cert2_title', 'ISO 9001 Quality Management'); ?>
                            </h3>

                            <p class="text-base sm:text-lg text-gray-700 leading-relaxed mb-4 sm:mb-6">
                                <?php echo t('certificates_page.cert2_desc', 'ISO 9001 Quality Certification Award, demonstrating our commitment to international quality management standards and continuous improvement'); ?>
                            </p>

                            <!-- Features List -->
                            <div class="space-y-3 sm:space-y-4">
                                <div class="flex items-start gap-3">
                                    <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert2_feature1', 'Global Recognition'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert2_feature1_desc', 'Accepted worldwide as quality benchmark'); ?></p>
                                    </div>
                                </div>

                                <div class="flex items-start gap-3">
                                    <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert2_feature2', 'Quality Assurance'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert2_feature2_desc', 'Systematic approach to quality management'); ?></p>
                                    </div>
                                </div>

                                <div class="flex items-start gap-3">
                                    <div class="flex-shrink-0 w-6 h-6 bg-primary-600 rounded-full flex items-center justify-center mt-1">
                                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="font-semibold text-gray-900"><?php echo t('certificates_page.cert2_feature3', 'Continuous Improvement'); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo t('certificates_page.cert2_feature3_desc', 'Commitment to ongoing excellence'); ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-6 sm:mt-8 flex items-center gap-2 text-primary-600 font-bold">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <span><?php echo t('certificates_page.cert2_status', 'Internationally Recognized Standard'); ?></span>
                            </div>
                        </div>

                        <!-- Image Side -->
                        <div class="relative bg-white p-6 sm:p-8 lg:p-12 flex items-center justify-center">
                            <div class="relative max-w-md w-full mx-auto">
                                <!-- Decorative Background -->
                                <div class="absolute inset-0 bg-primary-600 opacity-5 rounded-2xl transform rotate-3"></div>
                                <div class="absolute inset-0 bg-primary-600 opacity-5 rounded-2xl transform -rotate-3"></div>
                                
                                <!-- Certificate Image -->
                                <div class="relative bg-white rounded-2xl shadow-2xl overflow-hidden border border-gray-200 transform hover:scale-105 transition-transform duration-500">
                                    <img 
                                        src="https://smartive.com.sa/assets/imgs/certificate/cert-2.png" 
                                        alt="ISO 9001 Certificate" 
                                        class="w-full h-auto object-contain"
                                    />
                                </div>

                                <!-- Floating Badge -->
                                <div class="absolute -top-3 -left-3 sm:-top-4 sm:-left-4 bg-primary-600 text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-xl shadow-xl z-10">
                                    <div class="flex items-center gap-2">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        <span class="font-bold"><?php echo t('certificates_page.cert2_badge', 'ISO Certified'); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<?php include __DIR__ . '/inc/footer.php'; ?>