<?php
require_once __DIR__ . '/inc/utils.php';
$pageTitle = 'Career - Altoukhi';
$pageDescription = 'Join our team at Altoukhi';
$activePage = 'career';

// Language detection logic
$i18n = detect_lang();
$lang = $i18n['lang'];
$translations = load_translations();

include __DIR__ . '/inc/header.php';
?>

    <!-- Page Header -->
    <section class="relative bg-primary-600 text-white py-12 md:py-20 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
        
        <div class="absolute top-0 left-0 w-24 h-24 bg-gradient-to-br from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute top-0 right-0 w-24 h-24 bg-gradient-to-bl from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute bottom-0 left-0 w-24 h-24 bg-gradient-to-tr from-black/15 to-transparent rounded-full blur-2xl"></div>
        <div class="absolute bottom-0 right-0 w-24 h-24 bg-gradient-to-tl from-black/15 to-transparent rounded-full blur-2xl"></div>
        
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-80 h-80 bg-white/3 rounded-full blur-2xl"></div>
        
        <div class="container mx-auto px-4 text-center relative z-10">
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 sm:mb-4 md:mb-6 drop-shadow-md"><?php echo t('nav.career'); ?></h2>
            <p class="text-base sm:text-lg md:text-xl max-w-2xl mx-auto opacity-90 drop-shadow-sm"><?php echo t('career_page.your_career_starts'); ?></p>
        </div>
    </section>

    <!-- Career Section: Two Columns -->
    <section class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-3 gap-8 md:gap-10 items-start rtl:text-right ltr:text-left">
                <div class="md:col-span-2 space-y-6 md:space-y-8">
                    <div class="relative">
                        <div class="absolute -top-4 -left-4 w-24 h-24 bg-primary-100 rounded-full opacity-50"></div>
                        <div class="absolute -bottom-2 -right-2 w-16 h-16 bg-primary-200 rounded-full opacity-30"></div>
                        
                        <div class="relative z-10">
                            <div class="inline-flex items-center gap-2 bg-primary-50 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-4 md:mb-6">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2-2v2m8 0V6a2 2 0 012 2v6a2 2 0 01-2 2H6a2 2 0 01-2-2V8a2 2 0 012-2V6"/>
                                </svg>
                                <?php echo t('nav.career'); ?>
                            </div>
                            
                            <h1 class="text-3xl sm:text-4xl md:text-6xl font-extrabold mb-4 md:mb-6 text-gray-900 leading-tight rtl:text-right ltr:text-left">
                                <?php echo t('career_page.hero_title'); ?>
                            </h1>
                            
                            <div class="space-y-3 md:space-y-4 mb-6 md:mb-8">
                                <p class="text-base sm:text-lg md:text-xl text-gray-700 leading-relaxed rtl:text-right ltr:text-left"><?php echo t('career_page.hero_intro'); ?></p>
                                <p class="text-base sm:text-lg md:text-xl text-gray-700 leading-relaxed rtl:text-right ltr:text-left"><?php echo t('career_page.hero_intro2'); ?></p>
                            </div>
                            
                            <div class="inline-flex items-center gap-2 md:gap-3 bg-gradient-to-r from-primary-50 to-primary-100 border border-primary-200 rounded-xl px-4 md:px-6 py-3 md:py-4">
                                <div class="w-3 h-3 bg-primary-600 rounded-full animate-pulse"></div>
                                <p class="text-base md:text-lg text-primary-800 font-semibold rtl:text-right ltr:text-left"><?php echo t('career_page.your_career_starts'); ?></p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bg-gradient-to-br from-gray-50 to-white rounded-2xl p-6 md:p-8 border border-gray-100 shadow-sm">
                        <div class="flex items-center gap-3 mb-4 md:mb-6">
                            <div class="w-10 h-10 md:w-12 md:h-12 bg-primary-600 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </div>
                            <h2 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-900 rtl:text-right ltr:text-left"><?php echo t('career_page.what_expect_title'); ?></h2>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3 md:gap-4 mb-6 md:mb-8">
                            <?php 
                                $expectItems = $translations[$lang]['career_page']['what_expect_items'] ?? [];
                                
                                $lucideIcons = [
                                    'users', 
                                    'check-circle',                 
                                    'trending-up', 
                                    'clock', 
                                    'network', 
                                    'award' 
                                ];
                                
                                foreach ((array)$expectItems as $index => $item): 
                                    $iconName = $lucideIcons[$index] ?? $lucideIcons[0]; 
                            ?>
                                <div class="flex items-start gap-3 md:gap-4 p-4 bg-white rounded-xl border border-gray-100 hover:border-primary-200 transition-colors rtl:text-right ltr:text-left">
                                    <div class="flex-shrink-0 w-9 h-9 md:w-10 md:h-10 bg-primary-100 text-primary-600 rounded-xl flex items-center justify-center">
                                        <i data-lucide="<?php echo $iconName; ?>" class="w-5 h-5"></i>
                                    </div>
                                    <p class="text-gray-700 leading-relaxed text-sm sm:text-base"><?php echo htmlspecialchars($item); ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        
                        <div class="bg-primary-50 border border-primary-200 rounded-xl p-6 mb-6">
                            <p class="text-gray-800 text-lg leading-relaxed"><?php echo t('career_page.cta_paragraph'); ?></p>
                        </div>
                        
                        <a href="#open-positions" class="inline-flex items-center gap-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold px-8 py-4 rounded-xl transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                            <?php echo t('career_page.cta_button'); ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                            </svg>
                        </a>
                    </div>
                </div>
                
                <!-- Right column: Contact Card -->
                <div class="sticky top-8">
                    <div class="bg-primary-600 rounded-2xl p-6 md:p-8 text-white shadow-2xl">
                        <div class="text-center mb-6 md:mb-8">
                            <div class="w-16 h-16 md:w-20 md:h-20 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-4 md:mb-6">
                                <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                                </svg>
                            </div>
                            <h3 class="text-2xl md:text-3xl font-bold mb-4 md:mb-6 rtl:text-right ltr:text-left">How can we help you?</h3>
                            <p class="text-base md:text-lg text-white/90 leading-relaxed rtl:text-right ltr:text-left">
                                Al Toukhi Company become one of the leading trading and contacting companies in all region of the Saudi Arabia
                            </p>
                        </div>
                        
                        <div class="space-y-5 md:space-y-6 mb-6 md:mb-8">
                            <div class="flex items-center gap-3 md:gap-4 rtl:flex-row-reverse text-left rtl:text-right">
                                <div class="w-12 h-12 md:w-14 md:h-14 bg-white/20 rounded-full flex items-center justify-center shrink-0">
                                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-sm md:text-base text-white/70 mb-0.5 md:mb-1">Phone</p>
                                    <p class="text-lg md:text-xl font-semibold">011 2766655</p>
                                </div>
                            </div>
                            
                            <div class="flex items-center gap-3 md:gap-4 rtl:flex-row-reverse text-left rtl:text-right">
                                <div class="w-12 h-12 md:w-14 md:h-14 bg-white/20 rounded-full flex items-center justify-center shrink-0">
                                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-sm md:text-base text-white/70 mb-0.5 md:mb-1">Email</p>
                                    <p class="text-lg md:text-xl font-semibold">information@altoukhi.com</p>
                                </div>
                            </div>
                        </div>
                        
                        <a href="<?php echo $i18n['prefix']; ?>/contact" class="w-full bg-white text-primary-600 hover:bg-white/90 font-semibold py-3 md:py-4 px-6 rounded-lg transition duration-300 flex items-center justify-center gap-2 md:gap-3 text-base md:text-lg">
                            <?php echo t('nav.contact'); ?>
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Open positions -->
    <section id="open-positions" class="py-12 md:py-16 bg-white">
        <div class="container mx-auto px-4 max-w-5xl">
            <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 md:mb-6 rtl:text-right ltr:text-left"><?php echo t('career_page.open_positions'); ?></h2>
            <div class="rounded-xl border border-gray-200 p-6 md:p-8 text-center text-gray-600 text-sm md:text-base">
                <?php echo t('career_page.empty_state'); ?>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/inc/footer.php'; ?>


