<?php
require_once __DIR__ . '/inc/utils.php';
$i18n = detect_lang();
$pageTitle = 'Altoukhi - ' . t('about_page.header_title', 'About Us');
$pageDescription = t('about_page.header_desc', 'About Altoukhi Company');
$activePage = 'about';
include __DIR__ . '/inc/header.php';
?>

    <!-- Page Header -->
 <section class="relative bg-primary-600 text-white py-16 sm:py-20 lg:py-24 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-b from-black/10 via-transparent to-black/15"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/5 via-transparent to-black/5"></div>
     <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-56 h-56 sm:w-72 sm:h-72 lg:w-80 lg:h-80 bg-white/5 rounded-full blur-3xl"></div>

     <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
         <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold mb-3 sm:mb-4 drop-shadow-md"><?php echo t('about_page.header_title'); ?></h1>
         <p class="text-base sm:text-lg md:text-xl max-w-3xl mx-auto opacity-95 drop-shadow-sm"><?php echo t('about_page.header_desc'); ?></p>
        </div>
    </section>

<!-- Main Content Section -->
 <section class="py-12 sm:py-16 lg:py-20 bg-white">
     <div class="container mx-auto px-4 sm:px-6 lg:px-8">
         <div class="grid md:grid-cols-2 gap-8 sm:gap-10 lg:gap-12 items-start">
            
            <!-- Text Content Column -->
             <div class="space-y-5 sm:space-y-6">
                <!-- Company Badge -->
                 <div class="inline-flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-1.5 sm:py-2 bg-primary-100 text-primary-600 rounded-full text-xs sm:text-sm font-semibold">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    <span><?php echo t('about_page.section_title', 'About Company'); ?></span>
                </div>

                <!-- Main Heading -->
                 <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold text-gray-900 leading-tight">
                    <strong><?php echo t('about_page.company_name', 'Altoukhi'); ?></strong>
                </h2>

                <!-- Description Paragraphs -->
                 <div class="space-y-3 sm:space-y-4 text-gray-700 text-base sm:text-lg leading-relaxed">
                    <p><?php echo t('about_page.body_p1'); ?></p>
                    <p><?php echo t('about_page.body_p2'); ?></p>
                </div>

                <!-- Feature List with Icons -->
                
                 <div class="space-y-4 pt-2 sm:pt-4">
                    <div class="flex items-start gap-3">
                         <div class="flex-shrink-0 w-9 h-9 sm:w-10 sm:h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                             <svg class="w-4 h-4 sm:w-5 sm:h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <div>
                             <h3 class="font-semibold text-gray-900 mb-0.5 sm:mb-1"><?php echo t('about_page.feature1_title', 'Quality Excellence'); ?></h3>
                             <p class="text-gray-600 text-xs sm:text-sm"><?php echo t('about_page.feature1_desc', 'Delivering exceptional quality in every project we undertake'); ?></p>
                        </div>
                    </div>

                    <div class="flex items-start gap-3">
                         <div class="flex-shrink-0 w-9 h-9 sm:w-10 sm:h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                             <svg class="w-4 h-4 sm:w-5 sm:h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <div>
                             <h3 class="font-semibold text-gray-900 mb-0.5 sm:mb-1"><?php echo t('about_page.feature2_title', 'Innovation First'); ?></h3>
                             <p class="text-gray-600 text-xs sm:text-sm"><?php echo t('about_page.feature2_desc', 'Using cutting-edge technology and modern solutions'); ?></p>
                        </div>
                    </div>

                    <div class="flex items-start gap-3">
                         <div class="flex-shrink-0 w-9 h-9 sm:w-10 sm:h-10 bg-primary-100 rounded-lg flex items-center justify-center">
                             <svg class="w-4 h-4 sm:w-5 sm:h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                             <h3 class="font-semibold text-gray-900 mb-0.5 sm:mb-1"><?php echo t('about_page.feature3_title', 'On-Time Delivery'); ?></h3>
                             <p class="text-gray-600 text-xs sm:text-sm"><?php echo t('about_page.feature3_desc', 'Committed to meeting deadlines without compromising quality'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Stats Row -->
                 <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 sm:gap-6 pt-6 sm:pt-8 border-t border-gray-200">
                    <div>
                        <div class="flex items-center gap-2 mb-1">
                            <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                             <span class="text-2xl sm:text-3xl font-bold text-gray-900">40+</span>
                         </div>
                         <p class="text-xs sm:text-sm text-gray-600"><?php echo t('about_page.stat_years', 'Years Experience'); ?></p>
                    </div>

                    <div>
                        <div class="flex items-center gap-2 mb-1">
                            <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                             <span class="text-2xl sm:text-3xl font-bold text-gray-900">500+</span>
                         </div>
                         <p class="text-xs sm:text-sm text-gray-600"><?php echo t('about_page.stat_projects', 'Projects Completed'); ?></p>
                    </div>

                    <div>
                        <div class="flex items-center gap-2 mb-1">
                            <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                             <span class="text-2xl sm:text-3xl font-bold text-gray-900">98%</span>
                         </div>
                         <p class="text-xs sm:text-sm text-gray-600"><?php echo t('about_page.stat_satisfaction', 'Client Satisfaction'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Image Column with Badges -->
             <div class="relative mt-10 md:mt-0">
                <!-- Main Image Container -->
                 <div class="relative rounded-2xl overflow-hidden shadow-xl border border-gray-200">
                    <img 
                        src="<?php echo compute_base_prefix(); ?>/assets/img/about/who-we-are-1.png" 
                        alt="About Altoukhi" 
                        class="w-full h-full object-cover aspect-[16/10] sm:aspect-[4/3] md:aspect-[4/5]"
                    />
                    
                    <!-- Gradient Overlay -->
                    <div class="absolute inset-0 bg-gradient-to-t from-black/50 via-transparent to-transparent"></div>
                </div>

                <!-- Floating Badge 1 - Top Right -->
                 <div class="absolute top-2 right-2 md:-top-3 md:-right-3 bg-white rounded-xl shadow-xl p-2.5 md:p-3 border-2 border-gray-100 z-10">
                    <div class="flex items-center gap-2">
                        <div class="w-10 h-10 bg-primary-600 rounded-lg flex items-center justify-center">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                </div>
                <div>
                             <p class="text-lg md:text-xl font-bold text-gray-900 leading-none">ISO</p>
                             <p class="text-[10px] md:text-xs text-primary-600 font-semibold"><?php echo t('about_page.badge_certified', 'Certified'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Floating Badge 2 - Bottom Left -->
                 <div class="absolute bottom-2 left-2 md:-bottom-3 md:-left-3 bg-primary-600 text-white rounded-xl shadow-xl p-3 md:p-4 z-10">
                    <div class="flex items-center gap-3">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        <div>
                             <p class="text-xl md:text-2xl font-bold leading-none mb-0.5 md:mb-1">50+</p>
                             <p class="text-[10px] md:text-xs font-medium opacity-90"><?php echo t('about_page.badge_team', 'Experts'); ?></p>
                        </div>
                    </div>
                </div>

                
            </div>

        </div>

                        </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Values Section -->
<section class="py-20 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="inline-block text-sm font-bold text-primary-600 uppercase tracking-widest mb-4">
                <?php echo t('about_page.values_subtitle', 'Our Core Values'); ?>
            </span>
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
                <?php echo t('about_page.values_title', 'What Drives Us Forward'); ?>
            </h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                <?php echo t('about_page.values_desc', 'Our principles guide every decision and action we take'); ?>
            </p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Value Card 1 -->
            <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-200 hover:border-primary-600">
                <div class="absolute top-0 right-0 w-32 h-32 bg-primary-600 opacity-5 rounded-2xl transform translate-x-8 -translate-y-8 group-hover:scale-110 transition-transform duration-300"></div>
                <div class="relative">
                    <div class="w-16 h-16 bg-primary-600 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">
                        <?php echo t('about_page.value1_title', 'Innovation'); ?>
                    </h3>
                    <p class="text-gray-600 leading-relaxed">
                        <?php echo t('about_page.value1_desc', 'Constantly pushing boundaries and embracing new technologies'); ?>
                    </p>
                </div>
            </div>

            <!-- Value Card 2 -->
            <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-200 hover:border-primary-600">
                <div class="absolute top-0 right-0 w-32 h-32 bg-primary-600 opacity-5 rounded-2xl transform translate-x-8 -translate-y-8 group-hover:scale-110 transition-transform duration-300"></div>
                <div class="relative">
                    <div class="w-16 h-16 bg-primary-600 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">
                        <?php echo t('about_page.value2_title', 'Quality'); ?>
                    </h3>
                    <p class="text-gray-600 leading-relaxed">
                        <?php echo t('about_page.value2_desc', 'Never compromising on excellence in every detail'); ?>
                    </p>
                </div>
            </div>

            <!-- Value Card 3 -->
            <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-200 hover:border-primary-600">
                <div class="absolute top-0 right-0 w-32 h-32 bg-primary-600 opacity-5 rounded-2xl transform translate-x-8 -translate-y-8 group-hover:scale-110 transition-transform duration-300"></div>
                <div class="relative">
                    <div class="w-16 h-16 bg-primary-600 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">
                        <?php echo t('about_page.value3_title', 'Teamwork'); ?>
                    </h3>
                    <p class="text-gray-600 leading-relaxed">
                        <?php echo t('about_page.value3_desc', 'Collaborating seamlessly to achieve exceptional results'); ?>
                    </p>
                </div>
            </div>

            <!-- Value Card 4 -->
            <div class="group relative bg-white rounded-2xl p-8 shadow-lg hover:shadow-xl transition-all duration-300 border border-gray-200 hover:border-primary-600">
                <div class="absolute top-0 right-0 w-32 h-32 bg-primary-600 opacity-5 rounded-2xl transform translate-x-8 -translate-y-8 group-hover:scale-110 transition-transform duration-300"></div>
                <div class="relative">
                    <div class="w-16 h-16 bg-primary-600 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-3">
                        <?php echo t('about_page.value4_title', 'Integrity'); ?>
                    </h3>
                    <p class="text-gray-600 leading-relaxed">
                        <?php echo t('about_page.value4_desc', 'Building trust through transparency and honesty'); ?>
                    </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include __DIR__ . '/inc/footer.php'; ?>