<?php
// 404 Page - Simple error page with multi-language support
require_once __DIR__ . '/inc/utils.php';

// Set HTTP 404 status
http_response_code(404);

$pageTitle = '404 - ' . t('error_404.page_title');
$pageDescription = t('error_404.page_description');
$activePage = '404';

include __DIR__ . '/inc/header.php';
?>

<section class="min-h-screen flex items-center justify-center bg-gray-50 py-16">
    <div class="container mx-auto px-4 text-center">
        <div class="max-w-2xl mx-auto">
            <!-- 404 Number -->
            <div class="mb-8">
                <h1 class="text-9xl font-bold text-primary-600 mb-4">404</h1>
                <div class="w-24 h-1 bg-primary-600 mx-auto"></div>
            </div>
            
            <!-- Error Message -->
            <div class="mb-8">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">
                    <?php echo t('error_404.title'); ?>
                </h2>
                <p class="text-lg text-gray-600 mb-6">
                    <?php echo t('error_404.description'); ?>
                </p>
            </div>
            
            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo $langPrefix; ?>/" class="btn-asym inline-flex items-center justify-center px-6 py-3 font-semibold text-white bg-primary-600 hover:bg-primary-700 focus:outline-none focus-visible:ring-2 focus-visible:ring-primary-300">
                    <i data-lucide="home" class="w-5 h-5 <?php echo $lang === 'ar' ? 'ml-2' : 'mr-2'; ?>"></i>
                    <?php echo t('error_404.back_to_home'); ?>
                </a>
                <a href="<?php echo $langPrefix; ?>/contact.php" class="btn-asym-mirror inline-flex items-center justify-center px-6 py-3 font-semibold text-primary-700 bg-white border border-gray-200 hover:text-primary-800 hover:border-primary-200">
                    <i data-lucide="message-circle" class="w-5 h-5 <?php echo $lang === 'ar' ? 'ml-2' : 'mr-2'; ?>"></i>
                    <?php echo t('error_404.contact_us'); ?>
                </a>
            </div>
        </div>
    </div>
</section>

<?php include __DIR__ . '/inc/footer.php'; ?>
